<?php
namespace boru\backblaze;

use \boru\dhutils\dhGlobal;

class BackBlazeBase {

    protected $debug_name = "backblaze";
    protected $debug_prefix = "BACKBLAZE";
    public $debugDoTrace = false;

    public function setupDebug() {
        dhGlobal::addLogLevel($this->debug_name."-t","trace","TRACE"); //_trace()
        dhGlobal::addLogLevel($this->debug_name."-d","debug","DEBUG"); //_debug()
        dhGlobal::addLogLevel($this->debug_name."-i","info"," INFO"); //_info()
        dhGlobal::addLogLevel($this->debug_name."-w","warn"," WARN"); //_warn()
        dhGlobal::addLogLevel($this->debug_name."-e","error","ERROR"); //_error()
    }

    protected function _trace(...$args) {
        if($this->debugDoTrace) {
            array_unshift($args,$this->debug_prefix." - ");
            array_unshift($args,$this->debug_name."-t");
            return call_user_func_array([$this,"log"],$args);
        }
        return;
    }
    protected function _debug(...$args) {
        array_unshift($args,$this->debug_prefix." - ");
        array_unshift($args,$this->debug_name."-d");
        return call_user_func_array([$this,"log"],$args);
    }
    protected function _info(...$args) {
        array_unshift($args,$this->debug_prefix." - ");
        array_unshift($args,$this->debug_name."-i");
        return call_user_func_array([$this,"log"],$args);
    }
    protected function _warn(...$args) {
        array_unshift($args,$this->debug_prefix." - ");
        array_unshift($args,$this->debug_name."-w");
        return call_user_func_array([$this,"log"],$args);
    }
    protected function _error(...$args) {
        array_unshift($args,$this->debug_prefix." - ");
        array_unshift($args,$this->debug_name."-e");
        return call_user_func_array([$this,"log"],$args);
    }
    public function log(...$args) {
        return dhGlobal::log(...$args);
    }
}

class BackBlazeBaseException extends \Exception {
    protected $debug_name = "backblaze";
    public function __construct($method,$message=null,$code=null) {
        if(!is_null($message)) {
            dhGlobal::log($this->debug_name."-e",$method." ".$code." ".print_r($message,true));
        }
        parent::__construct($message,$code);
    }
}