<?php
namespace boru\backblaze;

use \boru\backblaze\parts\traits\TraitLog;

use \boru\backblaze\Client;
use boru\backblaze\parts\Bucket;
use boru\dhutils\dhGlobal;

class Buckets {
    const T_PUBLIC = 'allPublic';
    const T_PRIVATE = 'allPrivate';
    use TraitLog;

    protected $_bucketCacheLastList = 0;
    protected $_bucketCache = [];
    public $bucketCacheTime = 300; //seconds

    protected $debug_name = "backblaze";
    protected $debug_prefix = "BBBucket";
    public $debugDoTrace = false;

    /** @var Client */
    protected $client;

    public function __construct($clientOrOptions) {
        if(is_object($clientOrOptions) && $clientOrOptions instanceof Client) {
            $this->client = $clientOrOptions;
        } elseif(is_array($clientOrOptions)) {
            $this->client = Client::fromAuthArray($clientOrOptions);
        }
        if(is_null($this->client)) {
            throw new \Exception(__CLASS__." - failed constructor, client or auth array invalid");
        }
    }

            
    /**
     * list
     *
     * @param  bool $force 
     * @return \boru\backblaze\parts\Bucket[]
     */
    public function listBuckets($force=false) {
        $this->_trace("funcStart",__METHOD__);
        if(!$force && (time() - $this->_bucketCacheLastList) < $this->bucketCacheTime && !empty($this->_bucketCache)) {
            $this->_trace("funcEnd (cache-hit)",__METHOD__);
            $this->_trace("listBuckets (cache) successful",count($this->_bucketCache),"returned");
            return $this->_bucketCache;
        }
        $buckets = [];
        $params = [
            "accountId"=>$this->client->getAccountId(),
        ];
        $request = $this->client->request("post","/b2_list_buckets",$params);
        if(($response = $request->jsonParseSend()) !== false) {
            if(isset($response["buckets"])) {
                foreach($response["buckets"] as $bucket) {
                    $buckets[] = new Bucket($bucket);
                }
            }
        }
        $this->_trace("listBuckets successful",count($buckets),"returned");
        $this->_trace("funcEnd",__METHOD__);
        $this->_bucketCache = $buckets;
        $this->_bucketCacheLastList = time();
        return $buckets;
    }

    public function create($bucketName,$type=Bucket::T_PRIVATE) {
        $this->_trace("funcStart",__METHOD__);
        $params = [
            "bucketType"=>$type,
            "bucketName"=>$bucketName,
            "accountId"=>$this->client->getAccountId()
        ];
        $request = $this->client->request("post","/b2_create_bucket",$params);
        if(($response = $request->jsonParseSend()) !== false) {
            $this->_trace("createBucket successful",$response["bucketName"]);
            $this->_trace("funcEnd",__METHOD__);
            $bucket = new Bucket($response);
            $this->_bucketCache[$bucket->get("bucketId")] = $bucket;
            return $bucket;
        }
        $this->_trace("funcEnd",__METHOD__);
        return false;
    }

    public function getBy($option="bucketName",$value) {
        $this->_trace("funcStart",__METHOD__);
        $buckets = $this->listBuckets();
        foreach($buckets as $bucket) {
            if($bucket->get($option) == $value) {
                $this->_trace("funcEnd",__METHOD__);
                return $bucket;
            }
        }
        $this->_trace("funcEnd",__METHOD__);
        return false;
    }

    public function fromOptions($options=[],$justId=false) {
        $this->_trace("funcStart",__METHOD__);
        if(isset($options["bucket"])) {
            $this->_trace("funcEnd",__METHOD__);
           return $options["bucket"];
        } elseif(isset($options["bucketId"])) {
            $this->_trace("funcEnd",__METHOD__);
            return $this->getBy("bucketId",$options["bucketId"]);
        } elseif(isset($options["bucketName"])) {
            $this->_trace("funcEnd",__METHOD__);
            return $this->getBy("bucketName",$options["bucketName"]);
        }
        $this->_trace("funcEnd",__METHOD__);
        return false;
    }
}