<?php
namespace boru\backblaze;

use \boru\backblaze\Client;
use \boru\backblaze\Bucket;
use \boru\backblaze\File as bFile;
use \boru\dhutils\filesys\Directory;
use \boru\dhutils\dhGlobal;

class UploadTool {
    protected $client;
    protected $directories = [];
    public function __construct($keyId,$applicationKey,$options=[]) {
        dhGlobal::addLogLevel("uptool-t","trace","TRACE"); //_trace()
        dhGlobal::addLogLevel("uptool-d","debug","DEBUG"); //_debug()
        dhGlobal::addLogLevel("uptool-i","info"," INFO"); //_info()
        dhGlobal::addLogLevel("uptool-w","warn"," WARN"); //_warn()
        dhGlobal::addLogLevel("uptool-e","error","ERROR"); //_error()

        $accountInfo = isset($options["accountInfo"]) ? $options["accountInfo"] : [];
        //$this->client = new Client($keyId,$applicationKey,$accountInfo);

        $this->fileList = dhGlobal::getDot($options,"fileList",[]);
        $dir = dhGlobal::getDot($options,"dir",false);
        if($dir !== false) {
            $this->initDir($dir);
        }
    }

    public function initDir($initDir,$seperator=DIRECTORY_SEPARATOR) {
        $directories = [];
        if(is_array($initDir)) {
            $directories = $initDir;
        } else {
            $directories = [$initDir];
        }
        foreach($directories as $directory) {
            $this->directories[] = new Directory($directory,true,true);
        }
        return $this->fileList;
    }
    

    protected function _trace(...$args) {
        if($this->debugDoTrace) {
            array_unshift($args,"UploadTool -");
            array_unshift($args,"blaze-t");
            return call_user_func_array([$this,"log"],$args);
        }
        return;
    }
    protected function _debug(...$args) {
        array_unshift($args,"UploadTool -");
        array_unshift($args,"blaze-d");
        return $this->log($args);
    }
    protected function _info(...$args) {
        array_unshift($args,"UploadTool -");
        array_unshift($args,"blaze-i");
        return call_user_func_array([$this,"log"],$args);
    }
    protected function _warn(...$args) {
        array_unshift($args,"UploadTool -");
        array_unshift($args,"blaze-w");
        return call_user_func_array([$this,"log"],$args);
    }
    protected function _error(...$args) {
        array_unshift($args,"UploadTool -");
        array_unshift($args,"blaze-e");
        return call_user_func_array([$this,"log"],$args);
    }
    public function log(...$args) {
        return dhGlobal::log(...$args);
    }
}