<?php
namespace boru\backblaze;

use \boru\backblaze\parts\traits\TraitLog;
use \boru\dhutils\dhGlobal;
use \boru\dhutils\filesys\File;
use \boru\backblaze\exceptions\ClientException;
use \boru\backblaze\lib\Http;
use boru\dhutils\filesys\Directory;

class Account {
    use TraitLog;

    public $apiUrl = 'https://api.backblazeb2.com';
    public $apiVersion = "/b2api/v2";

    protected $debug_name = "backblaze";
    protected $debug_prefix = "BBACCT";
    public $debugDoTrace = false;
    
    protected $keyId;
    protected $applicationKey;
    protected $accountInfo;

    protected $authorized = false;

    protected $cacheFile;
    protected $cacheRemoveOnClose=false;

    public function __destruct() {
        if($this->cacheRemoveOnClose && is_object($this->cacheFile)) {
            $this->cacheFile->delete();
        }
    }
    public function __construct($keyId,$applicationKey,$options=[]) {
        $this->setupDebug();
        
        $this->setKeyId($keyId);
        $this->setApplicationKey($applicationKey);
        
        $this->initCache(dhGlobal::getDot($options,"cacheFile",""));
        $this->cacheRemoveOnClose = dhGlobal::getVal($options,"cacheRemoveOnClose",$this->cacheRemoveOnClose);

        $this->accountInfo = isset($options["accountInfo"]) ? $options["accountInfo"] : [];
        if(empty($this->accountInfo)) {
            $this->loadCache();
        }
        if(($this->get("accountId",false) === false || $this->get("authorizationToken",false) === false) && !is_null($this->getKeyId()) && !is_null($this->getApplicationKey())) {
            //$this->authorize();
        } else {
            $this->_trace("Loaded accountInfo from cache ".$this->cacheFile->path());
        }
        $this->checkAuthorized(true);
    }
    public function checkAuthorized($writeCache=false) {
        if($this->get("accountId",false) === false || $this->get("authorizationToken",false) === false) {
            $this->authorized = false;
        } else {
            $this->authorized = true;
            if($writeCache) {
                $this->writeCache();
            }
        }
        return $this->authorized;
    }
    
    public function get($item=null,$default=false) {
        $this->_trace("funcStart",__METHOD__);
        if(is_null($this->accountInfo)) {
            $this->_trace("funcEnd",__METHOD__);
            return $default;
        }
        if(is_null($item)) {
            $this->_trace("funcEnd",__METHOD__);
            return $this->accountInfo;
        } elseif(!isset($this->accountInfo[$item])) {
            $this->_trace("funcEnd",__METHOD__);
            return $default;
        }
        $this->_trace("funcEnd",__METHOD__);
        return $this->accountInfo[$item];
    }
    public function set($dotKey,$value=null) {
        dhGlobal::dotAssign($this->accountInfo,$dotKey,$value);
        return $this;
    }

    protected function initCache($cacheFilePath="") {
        $cleanupTime = "+60";
        if(empty($cacheFilePath)) {
            $this->cacheRemoveOnClose=true;
            $cacheFilePath = ".bbcache_".uniqid();
            $cleanupTime = "+5";
        }
        $dir = new Directory(["scan"=>false]);
        $files = $dir->find(["mmin"=>$cleanupTime,"name"=>'".bbcache*"']);
        if(!empty($files) && is_array($files)) {
            foreach($files as $file) {
                $file->delete();
            }
        }
        $this->cacheFile = new File([
            "path"=>$cacheFilePath,
            "readMeta"=>true,
            "create"=>true,
            "overwrite"=>false,
            "maxAge"=>60*60*3, //3 hours max life
        ]);
        return $this;
    }
    public function loadCache() {
        $cached = $this->cacheFile->content();
        if(!empty($cached)) {
            $j = json_decode($cached,true);
            if(is_array($j)) {
                $this->accountInfo = $j;
            }
        }
        return $this;
    }
    public function writeCache() {
        $this->cacheFile->write(json_encode($this->accountInfo));
        return $this;
    }

    

    /**
     * Get the value of keyId
     */ 
    public function getKeyId()
    {
        return $this->keyId;
    }

    /**
     * Set the value of keyId
     *
     * @return  self
     */ 
    public function setKeyId($keyId)
    {
        $this->keyId = $keyId;

        return $this;
    }

    /**
     * Get the value of applicationKey
     */ 
    public function getApplicationKey()
    {
        return $this->applicationKey;
    }

    /**
     * Set the value of applicationKey
     *
     * @return  self
     */ 
    public function setApplicationKey($applicationKey)
    {
        $this->applicationKey = $applicationKey;

        return $this;
    }

    /**
     * Get the value of accountInfo
     *
     * @return  mixed
     */
    public function getAccountInfo() {
        return $this->accountInfo;
    }

    /**
     * Set the value of accountInfo
     *
     * @param   mixed  $accountInfo  
     * @return  self
     */
    public function setAccountInfo($accountInfo) {
        $this->accountInfo = $accountInfo;
        return $this;
    }
}