<?php
namespace boru\backblaze\browser;

use boru\backblaze\Browser;
use boru\backblaze\parts\BucketFile;

class Listing {

    /** @var Folder[] */
    private $folders = [];
    /** @var File[] */
    private $files = [];

    /** @var int */
    private $fileCount=0;
    /** @var int */
    private $folderCount=0;

    public function __construct($files=[],$folders=[]) {
        $this->files = is_array($files) ? $files : [];
        $this->folders = is_array($folders) ? $folders : [];
        $this->fileCount = count($this->files);
        $this->folderCount = count($this->folders);
    }

    public function isEmpty() {
        if($this->fileCount>0 || $this->folderCount>0) {
            return false;
        }
        return true;
    }

    /** @return File[] */
    public function files() {
        return $this->files;
    }
    /** @return Folder[] */
    public function folders() {
        return $this->folders;
    }
    /** @return int */
    public function fileCount() {
        return $this->fileCount;
    }
    /** @return int */
    public function folderCount() {
        return $this->folderCount;
    }

    /**
     * @param mixed $name 
     * @return File|false 
     */
    public function file($name) {
        return isset($this->files[$name]) ? $this->files[$name] : false;
    }
    /**
     * @param mixed $name 
     * @return Folder|false 
     */
    public function folder($name) {
        return isset($this->folders[$name]) ? $this->folders[$name] : false;
    }

    /**
     * 
     * @param BucketFile[] $array
     * @param Browser|null $browser
     * @return self
     */
    public static function fromBucketFiles($array=[],$browser=null) {
        $files = [];
        $folders = [];
        foreach($array as $bucketFile) {
            $obj = Browser::fileOrFolder($bucketFile,$browser);
            if($bucketFile->get("action") == "folder") {
                $folders[$bucketFile->name()] = $obj;
            } else {
                $files[$bucketFile->name()] = $obj;
            }
        }
        return new self($files,$folders);
    }
}