<?php
namespace boru\backblaze\lib;

use \boru\backblaze\parts\traits\TraitLog;
use boru\dhutils\dhGlobal;

class Http {
    use TraitLog;

    public $apiUrl = 'https://api.backblazeb2.com';
    public $apiVersion = "/b2api/v2";

    protected $debug_name = "backblaze";
    protected $debug_prefix = "BACKBLAZE";
    public $debugDoTrace = false;

    protected $authorization;

    protected $account;

    protected $headers;
    protected $asJson = false;


    public function __construct($keyId,$applicationKey,$options=[]) {
        $this->account = new \boru\backblaze\Account($keyId,$applicationKey,$options);
        if(!$this->account->checkAuthorized()) {
            $this->authorize();
        }
    }

    public function apiUrl($uri) {
        if(substr($uri,0,4) != "http") {
            if(substr($uri,0,1) != "/") {
                $uri = "/".$uri;
            }
            $url = $this->account->get("apiUrl",$this->apiUrl);

            $url .= $this->apiVersion.$uri;
        } else {
            $url = $uri;
        }
        return $url;
    }


    public function authorize() {
        $this->_trace("funcStart",__METHOD__);
        $request = $this->request("get","/b2_authorize_account");
        $response = $this->asJson($request->send());
        if(is_array($response)) {
            $this->account->setAccountInfo($response);
            $this->account->checkAuthorized(true);
        } else {
            dhGlobal::error($response->body());
            $this->_trace("funcEnd",__METHOD__);
            return false;
        }
        $this->_trace("authorize successful");
        $this->_trace("funcEnd",__METHOD__);
        return true;
    }

    public function asJson($response) {
        if($response instanceof \boru\dhutils\http\Response) {
            return $response->body(true);
        }
        return $response;
    }

    /**
     * 
     * @param mixed $method 
     * @param mixed $url 
     * @param mixed $data 
     * @param bool $auth 
     * @param mixed $onSuccess 
     * @param mixed $onError 
     * @return Request 
     */
    public function request($method,$url,$data=null,$auth=true,$onSuccess=null,$onError=null) {
        $url = $this->apiUrl($url);
        if($auth) {
            if(($authToken = $this->account->get("authorizationToken",null)) !== null) {
                $auth = $authToken;
            } else {
                $auth = [$this->account->getKeyId(),$this->account->getApplicationKey()];
            }
        } else {
            $auth = null;
        }
        return new Request($method,$url,$data,$auth,$onSuccess,$onError);
    }

    /**
     * Get the value of account
     *
     * @return  \boru\backblaze\Account
     */
    public function getAccount() {
        return $this->account;
    }

    public function accountSet($dotKey,$value=null,$writeCache=false) {
        $this->account->set($dotKey,$value);
        if($writeCache) {
            $this->account->writeCache();
        }
        return $this;
    }
    public function accountGet($item=null,$default=false) {
        return $this->account->get($item,$default);
    }
}