<?php
namespace boru\backblaze\parts;

use boru\dhutils\dhGlobal;

class UploadPart {
    private $data = [
        "number"=>null,
        "size"=>0,
        "hash"=>"",
        "done"=>false,
        "started"=>false,
        "offset"=>0,
        "attempts"=>0,
        "content"=>"",
    ];

    public function __construct($number,$size,$hash,$offset=0) {
        $this->number($number);
        $this->size($size);
        $this->hash($hash);
        $this->offset($offset);
    }

    /**
     * Set or Get the value of number
     * @param mixed $number 
     * @param mixed $default 
     * @return mixed 
     */
    public function number($number=null,$default=null) {
        if(is_null($number)) return $this->get("number",$default);
        $this->set("number",$number);
        return $this;
    }
    /**
     * Set or Get the value of size
     * @param mixed $size 
     * @param mixed $default 
     * @return mixed 
     */
    public function size($size=null,$default=null) {
        if(is_null($size)) return $this->get("size",$default);
        $this->set("size",$size);
        return $this;
    }
    /**
     * Set or Get the value of hash
     * @param mixed $hash 
     * @param mixed $default 
     * @return mixed 
     */
    public function hash($hash=null,$default=null) {
        if(is_null($hash)) return $this->get("hash",$default);
        $this->set("hash",$hash);
        return $this;
    }
    /**
     * Set or Get the value of done
     * @param mixed $done 
     * @param mixed $default 
     * @return mixed 
     */
    public function done($done=null,$default=null) {
        if(is_null($done)) return $this->get("done",$default);
        $this->set("done",$done);
        return $this;
    }
    /**
     * Set or Get the value of started
     * @param mixed $started 
     * @param mixed $default 
     * @return mixed 
     */
    public function started($started=null,$default=null) {
        if(is_null($started)) return $this->get("started",$default);
        $this->set("started",$started);
        return $this;
    }
    /**
     * Set or Get the value of offset
     * @param mixed $offset 
     * @param mixed $default 
     * @return mixed 
     */
    public function offset($offset=null,$default=null) {
        if(is_null($offset)) return $this->get("offset",$default);
        $this->set("offset",$offset);
        return $this;
    }
    /**
     * Set or Get the value of attempts
     * @param mixed $attempts 
     * @param mixed $default 
     * @return mixed 
     */
    public function attempts($attempts=null,$default=null) {
        if(is_null($attempts)) return $this->get("attempts",$default);
        $this->set("attempts",$attempts);
        return $this;
    }
    public function incAttempts() {
        $attempts = $this->attempts(null,0);
        $attempts++;
        $this->attempts($attempts);
        return $this;
    }
    /**
     * Set or Get the value of content
     * @param mixed $content 
     * @param mixed $default 
     * @return mixed 
     */
    public function content($content=null,$default=null) {
        if(is_null($content)) return $this->get("content",$default);
        $this->set("content",$content);
        return $this;
    }

    /**
     * Get the value for $key. if $key is null, the whole array is returned.
     * @param null|mixed $key if null, returns the entire array. Otherwise, a dot-separated key to find in the configuration array
     * @param mixed $default default return value if $key isn't found/set
     * @return mixed 
     */
    public function get($key=null,$default=null) {
        if(is_null($key)) {
            return $this->data;
        }
        return dhGlobal::getVal($this->data,$key,$default);
    }
    /**
     * Set the value of $key
     * @param mixed $key 
     * @param mixed $value 
     * @return $this 
     */
    public function set($key,$value=null) {
        dhGlobal::dotAssign($this->data,$key,$value);
        return $this;
    }

}