<?php
namespace boru\backblaze\browser;

use boru\backblaze\Browser;
use boru\backblaze\Files;
use boru\backblaze\parts\BucketFile;

class Folder {
    /** @var Browser */
    private $browser;
    /** @var BucketFile */
    private $bucketFile;
    /** @var Listing */
    private $listing;

    /** @var string */
    private $path,$name,$bucketId;

    /**
     * @param BucketFile|string $bucketFileOrPathString
     * @param null|Browser $browser 
     * @return void 
     */
    public function __construct($bucketFileOrPathString,Browser $browser=null) {
        if(!is_null($browser)) {
            $this->browser = $browser;
        }
        if(is_object($bucketFileOrPathString) && method_exists($bucketFileOrPathString,"path")) {
           $this->setBucketFile($bucketFileOrPathString);
        } elseif(is_object($bucketFileOrPathString) || is_array($bucketFileOrPathString)) {
            throw new \Exception(__CLASS__." requires either a BucketFile or a path string as a constructor");
        } else {
            $this->setPath($bucketFileOrPathString);
        }
    }

    public function path() {
        return $this->getPath();
    }
    public function name() {
        return $this->getName();
    }
    public function bucketId() {
        return $this->getBucketId();
    }

    public function contents($useCache=true,$maxFiles=1000) {
        if(is_null($this->browser)) {
            throw new \Exception("Cannot get Folder contents without a browser attached");
        }
        if(!is_null($this->listing) && $useCache) {
            return $this->listing;
        }
        $listing = $this->browser->contents($this->path,$useCache,$maxFiles);
        if($useCache) {
            $this->listing = $listing;
        }
        return $listing;
    }

    /**
     * Set the value of browser
     * @param   Browser  $browser  
     * @return  self
	 */
    public function setBrowser(Browser $browser) {
        $this->browser = $browser;
        return $this;
    }
    
    /**
     * Set the value of bucketFile
     * @param   mixed  $bucketFile  
     * @return  self
	 */
    public function setBucketFile($bucketFile) {
        $this->bucketFile = $bucketFile;
        $this->setPath($this->bucketFile->path());
        $this->setName($this->bucketFile->name());
        $this->setBucketId($this->bucketFile->get("bucketId"));
        return $this;
    }

    /**
	 * Get the value of path
     * @return  mixed
     */
    public function getPath() {
        return $this->path;
    }

    /**
     * Set the value of path
     * @param   mixed  $path  
     * @return  self
	 */
    public function setPath($path) {
        $this->path = $path;
        return $this;
    }

    /**
	 * Get the value of name
     * @return  mixed
     */
    public function getName() {
        return $this->name;
    }

    /**
     * Set the value of name
     * @param   mixed  $name  
     * @return  self
	 */
    public function setName($name) {
        $this->name = $name;
        return $this;
    }

    /**
	 * Get the value of bucketId
     * @return  mixed
     */
    public function getBucketId() {
        return $this->bucketId;
    }

    /**
     * Set the value of bucketId
     * @param   mixed  $bucketId  
     * @return  self
	 */
    public function setBucketId($bucketId) {
        $this->bucketId = $bucketId;
        return $this;
    }
}