<?php
namespace boru\backblaze\browser;

use boru\backblaze\Browser;
use boru\backblaze\Files;
use boru\backblaze\parts\BucketFile;

class File {
    /** @var Browser */
    private $browser;
    /** @var BucketFile */
    private $bucketFile;

    /**
     * @param BucketFile $bucketFile
     * @param null|Browser $browser 
     * @return void 
     */
    public function __construct(BucketFile $bucketFile,Browser $browser=null) {
        if(!is_null($browser)) {
            $this->browser = $browser;
        }
        $this->bucketFile = $bucketFile;
    }

    public function download($headersOnly=false,$async=false) {
        if(is_null($this->browser)) {
            throw new \Exception("Cannot get download File without a browser attached");
        }
        return $this->browser->downloadByFileId($this->bucketFile->fileId());
    }
    public function delete($allVersions=false) {
        if(is_null($this->browser)) {
            throw new \Exception("Cannot delete File without a browser attached");
        }
        if($allVersions && !is_null($this->browser)) {
            $versions = $this->versions();
            foreach($versions as $version) {
                $this->browser->deleteFile($version->fileName(),$version->fileId());
            }
            return true;
        }
        return $this->browser->deleteFile($this->bucketFile->fileName(),$this->bucketFile->fileId());
    }

    public function get($dotKey=null,$default=null) {
        return $this->bucketFile->get($dotKey,$default);
    }

    public function modified($format=null) {
        return $this->bucketFile->modified($format);
    }
    public function uploaded($format=null) {
        return $this->bucketFile->uploaded($format);
    }
    public function name() {
        return $this->bucketFile->name();
    }
    public function path() {
        return $this->bucketFile->path();
    }
    public function fileName() {
        return $this->bucketFile->fileName();
    }
    public function fileId() {
        return $this->bucketFile->fileId();
    }
    public function fileInfo() {
        return $this->bucketFile->fileInfo();
    }
    public function sha1() {
        return $this->bucketFile->sha1();
    }
    public function contentType() {
        return $this->bucketFile->contentType();
    }
    public function action() {
        return $this->bucketFile->action();
    }
    public function size() {
        return $this->bucketFile->size();
    }
    public function accountId() {
        return $this->bucketFile->accountId();
    }
    public function bucketId() {
        return $this->bucketFile->bucketId();
    }
    public function fileRetention() {
        return $this->bucketFile->fileRetention();
    }
    /**
     * @param int $limit 
     * @return File[] 
     */
    public function versions($limit=100) {
        return $this->browser->getFileVersionsByName($this->fileName(),$limit);
    }

    /**
     * Set the value of browser
     * @param   Browser  $browser  
     * @return  self
	 */
    public function setBrowser(Browser $browser) {
        $this->browser = $browser;
        return $this;
    }

    /**
	 * Get the value of bucketFile
     * @return  mixed
     */
    public function getBucketFile() {
        return $this->bucketFile;
    }

    /**
     * Set the value of bucketFile
     * @param   mixed  $bucketFile  
     * @return  self
	 */
    public function setBucketFile($bucketFile) {
        $this->bucketFile = $bucketFile;
        return $this;
    }

    public static function fromFileName($fileName,Browser $browser) {
        return new self($browser->client()->files()->getByName($browser->getBucketId(),$fileName,false),$browser);
    }
}