<?php
namespace boru\backblaze\parts;

use boru\backblaze\browser\File;

class BucketFile extends \boru\dhutils\base\dhObject {
    protected $data = [
        "accountId"=>"",
        "action"=>"",
        "bucketId"=>"",
        "contentLength"=>"",
        "contentMd5"=>"",
        "contentSha1"=>"",
        "contentType"=>"",
        "fileId"=>"",
        "fileInfo"=>"",
        "fileName"=>"",
        "fileRetention"=>"",
        "legalHold"=>"",
        "serverSideEncryption"=>"",
        "uploadTimestamp"=>"",
        "name"=>"",
        "path"=>"",
        "isError"=>false,
        "errorMessage"=>"",
    ];
    public function __construct($arr=null,$separator=".") {
        parent::__construct($arr,$separator);
        $fileName = $this->get("fileName",null);
        if(!is_null($fileName)) {
            $parts = explode("/",$fileName);
            $name = array_pop($parts);
            if(empty($name)) {
                $name = array_pop($parts)."/";
            }
            $path = implode("/",$parts)."/";
            $this->set("name",$name);
            $this->set("path",$path);
        }
    }

    public function asFile($browser=null) {
        return new File($this,$browser);
    }

    public function modified($format=null) {
        return $this->fromMillisToFormat($this->get("fileInfo.src_last_modified_millis",false),$format);
    }
    public function uploaded($format=null) {
        return $this->fromMillisToFormat($this->get("uploadTimestamp",false),$format);
    }
    public function name() {
        return $this->get("name",null);
    }
    public function path() {
        return $this->get("path",null);
    }
    public function fileName() {
        return $this->get("fileName",null);
    }
    public function fileId() {
        return $this->get("fileId",null);
    }
    public function fileInfo() {
        return $this->get("fileInfo",null);
    }
    public function sha1() {
        $sha1 = $this->get("contentSha1",null);
        return $sha1 !== "none" ? $sha1 : $this->get("fileInfo.large_file_sha1", null);
    }
    public function contentType() {
        return $this->get("contentType",null);
    }
    public function action() {
        return $this->get("action",null);
    }
    public function size() {
        return $this->get("contentLength");
    }
    public function accountId() {
        return $this->get("accountId",null);
    }
    public function bucketId() {
        return $this->get("bucketId",null);
    }
    public function fileRetention() {
        return $this->get("fileRetention",null);
    }

    private function fromMillisToFormat($millis,$format=null) {
        if($millis !== false) {
            $timestamp = $millis/1000;
            $dt = new \DateTime(date("Y-m-d H:i:s",$timestamp));
            if(is_null($format)) { return $dt; }
            return $dt->format($format);
        }
        return false;
    }
}