<?php
namespace boru\bitbucket\api;

class Base {
	protected $user;
	protected $pass;
	
	protected $parse = "array"; //valid opts are false, "array", "object"
	
	protected $base_url = "https://git.boruapps.com";
	protected $api_path = "/rest/api/1.0";
	
	protected $debug = false;
	protected $debug_raw = false;
	
	public function __construct($user,$pass,$outputParseFormat="array") {
		$this->setUser($user);
		$this->setPass($pass);
		$this->setParse($outputParseFormat);
	}


	public function setUser($user) {
		$this->user = $user;
	}
	public function setPass($pass) {
		$this->pass = $pass;
	}
	public function setParse($parse) {
		$this->parse = $parse;
	}
	public function setBaseUrl($base_url) {
		$this->base_url = $base_url;
	}
	public function setApiPath($api_path) {
		$this->api_path = $api_path;
	}
	public function setDebug($debug) {
		$this->debug = $debug;
	}
	public function setDebugRaw($debug_raw) {
		$this->debug_raw = $debug_raw;
	}


	protected function _getUrl($rest="") {
		return $this->base_url.$this->api_path.$rest;
	}
	public function _call($type,$uri,$parms=array(),$ssl_verify=false,$customheader=array('Content-Type: application/json')) {
		if(substr($uri,0,4) != 'http')
			$uri = $this->_getUrl($uri);
		if(!is_array($customheader) || !is_object($customheader) || empty($customheader))
			$customheader=array('Content-Type: application/json');
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL,$uri);
		
		curl_setopt($ch, CURLOPT_USERPWD, $this->user.":".$this->pass);

		curl_setopt($ch, CURLOPT_URL,$uri);
		if($this->debug_raw)
			curl_setopt($ch, CURLOPT_VERBOSE, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $customheader);
		curl_setopt($ch, CURLOPT_HEADER,true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $ssl_verify);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		
		if($type !== "GET" && is_array($parms))
			$parms = json_encode($parms);
		
		switch($type) {
			case 'GET':
				if(!empty($parms)) {
					if(strpos($uri,"?") == false) $uri.='?';
					$uri.=http_build_query($parms);
				}
				break;
			case 'POST':
				curl_setopt($ch, CURLOPT_POST, true);
				curl_setopt($ch, CURLOPT_POSTFIELDS, $parms);
				break;
			case 'DELETE':
			case 'PUT':
			default:
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, strtoupper($type));
				curl_setopt($ch, CURLOPT_POSTFIELDS, $parms);
		}
		
		
		$response  = curl_exec($ch);
		$info = curl_getinfo($ch);
		curl_close($ch);
		
		$data = substr($response,$info['header_size']);
		if(!$this->parse) {
			if(strtolower($this->parse) == "array")
				$data = json_decode($data,true);
			else
				$data = json_decode($data);
		}
		
		$response = new Response($info['http_code'],trim(substr($response,0,$info['header_size'])),substr($response,$info['header_size']));
		
		return $response;
	}
	
	public function _get($uri,$parms=array(),$ssl_verify=false,$customheader="") {
		return $this->_call("GET",$uri,$parms,$ssl_verify,$customheader);
	}
	public function _post($uri,$parms=array(),$ssl_verify=false,$customheader="") {
		return $this->_call("POST",$uri,$parms,$ssl_verify,$customheader);
	}
	public function _put($uri,$parms=array(),$ssl_verify=false,$customheader="") {
		return $this->_call("PUT",$uri,$parms,$ssl_verify,$customheader);
	}
	public function _delete($uri,$parms=array(),$ssl_verify=false,$customheader="") {
		return $this->_call("DELETE",$uri,$parms,$ssl_verify,$customheader);
	}
}