<?php
namespace boru\bitbucket\api;

use \Exception;

class Project extends Base {
	public function get($name="") {
		if(!empty($name))
			return $this->_get("/projects?name=$name");	
		else
			return $this->_get("/projects");
	}
	public function create($key,$name,$description="") {
		if(empty($key))
			throw new Exception('Missing Key');
		if(empty($name))
			throw new Exception('Missing Name');
		$parms = array("key"=>$key,"name"=>$name,"description"=>$description);
		return $this->_post("/projects",$parms);
	}
	public function update($key,$name,$description="") {
		if(empty($key))
			throw new Exception('Missing Key');
		$parms["key"] = $key;
		if(!empty($name))
			$parms["name"] = $name;
		if(!empty($description))
			$parms["description"] = $description;
		if(count($parms)<=1)
			throw new Exception('Nothing to update');
		return $this->_put("/projects/$key",$parms);
	}
	public function delete($key) {
		if(empty($key))
			throw new Exception('Missing Key');
		return $this->_put("/projects/$key");
	}
}