<?php
namespace boru\bitbucket;

class Bitbucket {
    private $apiBase;
    private $apiProject;
    private $apiProjectRepos;

    public function __construct($user,$pass,$outputFormat="array") {
        $this->apiBase = new api\Base($user,$pass,$outputFormat);
        $this->apiProject = new api\Project($user,$pass,$outputFormat);
        $this->apiProjectRepos = new api\ProjectRepos($user,$pass,$outputFormat);
    }

    /**
     * @return api\Base
     */
    public function api() {
        return $this->apiBase;
    }
    /**
     * @return api\Project
     */
    public function project() {
        return $this->apiProject;
    }
    /**
     * @return api\ProjectRepos
     */
    public function projectRepos() {
        return $this->apiProjectRepos;
    }
}