<?php
namespace boru\bitbucket;

class Bitbucket {
    private $apiBase;
    private $apiProject;
    private $apiProjectRepos;

    public function __construct($user,$pass,$outputFormat="array") {
        $this->apiBase = new api\Base($user,$pass,$outputFormat);
        $this->apiProject = new api\Project($user,$pass,$outputFormat);
        $this->apiProjectRepos = new api\ProjectRepos($user,$pass,$outputFormat);
    }

    /**
     * @return \boru\bitbucket\api\Base
     */
    public function api() {
        return $this->apiBase;
    }
    /**
     * @return \boru\bitbucket\api\Project
     */
    public function project() {
        return $this->apiProject;
    }
    /**
     * @return \boru\bitbucket\api\ProjectRepos
     */
    public function projectRepos() {
        return $this->apiProjectRepos;
    }

    /**
     * @return \boru\bitbucket\api\Response
     */
    public function listRepos($projectKey) {
        return $this->projectRepos()->listRepos($projectKey);
    }
    /**
     * @return \boru\bitbucket\api\Response
     */
    public function getRepos($projectKey,$slug) {
        return $this->projectRepos()->get($projectKey,$slug);
    }
    /**
     * @return \boru\bitbucket\api\Response
     */
    public function createRepos($projectKey,$name) {
        return $this->projectRepos()->create($projectKey,$name);
    }
    /**
     * @return \boru\bitbucket\api\Response
     */
    public function updateRepos($projectKey,$repos,$data) {
        return $this->projectRepos()->update($projectKey,$repos,$data);
    }

    /**
     * @return \boru\bitbucket\api\Response
     */
    public function getProject($name="") {
        return $this->project()->get($name);
    }
    /**
     * @return \boru\bitbucket\api\Response
     */
    public function createProject($key,$name,$description="") {
        return $this->project()->create($key,$name,$description);
    }
    /**
     * @return \boru\bitbucket\api\Response
     */
    public function updateProject($key,$name,$description="") {
        return $this->project()->update($key,$name,$description);
    }
}