<?php
namespace boru\bitbucket\api;

use \Exception;

class ProjectRepos extends Base {
	public function listRepos($projectKey) {
		return $this->_get("/projects/$projectKey/repos?limit=500");
	}
	public function get($projectKey,$slug) {
		if(empty($projectKey))
			throw new Exception('Missing projectKey');
		if(empty($slug))
			throw new Exception('Missing slug');
		return $this->_get("/projects/$projectKey/repos/$slug");
	}
	public function create($projectKey,$name) {
		if(empty($projectKey))
			throw new Exception('Missing projectKey');
		if(empty($name))
			throw new Exception('Missing repository name');
		$parms = array("name"=>$name,"scmId"=>"git","forkable"=>true);
		return $this->_post("/projects/$projectKey/repos",$parms);
	}
	public function update($projectKey,$repos,$data) {
		if(empty($projectKey))
			throw new Exception('Missing projectKey');
		if(empty($repos))
			throw new Exception('Missing repository name');
		return $this->_put("/projects/$projectKey/repos/$repos",$data);
	}
	public function delete($projectKey,$slug) {
		if(empty($projectKey))
			throw new Exception('Missing projectKey');
		if(empty($slug))
			throw new Exception('Missing slug');
		return $this->_put("/projects/$projectKey/repos/$slug");
	}
}