<?php
namespace boru\boruai;

use boru\boruai\Cli\BoruAICLI;
use boru\boruai\Models\ChatSession;
use boru\boruai\Models\Document;
use boru\boruai\Models\File;
use boru\boruai\Models\Queue;
use boru\boruai\Models\ToolDefinition;
use boru\boruai\Tools\OCR;
use boru\dhprocess\Task;
use boru\dhprocess\TaskQueue;
use boru\dhprocess\Threader;
use boru\dhutils\dhGlobal;
use boru\output\Output;
use boru\qdrant\Qdrant;
use boru\query\Factory;

class BoruAI {
    private static $isInit = false;
    private static $debugMode = false;
    private static $debugHttp = false;

    public static function init($fileOrarray=null,$save=false) {
        if($fileOrarray === null) {
            if(defined("BORUAI_ROOT")) {
                $fileOrarray = BORUAI_ROOT."/config.json";
            } else {
                $fileOrarray = "config.json";
            }
        }
        if(is_array($fileOrarray)) {
            Config::loadManualConfig($fileOrarray);
        } else {
            Config::init($fileOrarray,$save);
        }
        if(!static::isInit()) {
            static::registerEntities();
        }
        static::$isInit=true;
    }
    public static function isInit() {
        return static::$isInit;
    }
    public static function verifyInit() {
        if(!static::isInit()) {
            throw new \Exception("OpenAI is not initialized. Please call OpenAI::init(\$api_key,\$api_version) first.");
        }
    }

    public static function outputDir($dir=null) {
        if($dir) {
            return Config::set("outputdir",$dir);
        }
        return Config::get("outputdir", __DIR__.'/../output/');
    }

    public static function bootstrapFile($file=null) {
        if($file) {
            return Config::set("threaderOptions.bootstrapFile",$file);
        }
        $rootDir = static::projectRoot();
        $bootstrap = $rootDir."/vendor/autoload.php";
        return Config::get("threaderOptions.bootstrapFile", $bootstrap);
    }

    public static function config($key,$default=null) {
        return Config::get($key,$default);
    }
    public static function setConfig($key,$value) {
        return Config::set($key,$value);
    }
    public static function saveConfig() {
        return Config::save();
    }
    public static function table($tableName) {
        return Config::get("tables.$tableName",false);
    }
    public static function isCLI() {
        return php_sapi_name() == "cli";
    }

    public static function debug($debug=null) {
        if($debug !== null) {
            static::$debugMode = $debug ? true : false;
        }
        return static::$debugMode ? true : false;
    }
    public static function debugHttp($debug=null) {
        if($debug !== null) {
            static::$debugHttp = $debug ? true : false;
        }
        return static::$debugHttp ? true : false;
    }

    public static function printDebug(...$messages) {
        if(static::debug()) {
            array_unshift($messages,"[DEBUG]");
            Output::outLine(...$messages);
        }
    }
    public static function printHttpDebug(...$messages) {
        if(static::debugHttp()) {
            array_unshift($messages,"[HTTP]");
            Output::outLine(...$messages);
        }
    }

    /**
     * @param string $path
     * @param array $paramaters
     * @return dhDB
     * @throws \Exception
     */
    public static function db($dbconfig=null) {
        if($dbconfig) {
            return dhGlobal::db($dbconfig);
        }
        if(!dhGlobal::db() && Config::get("dbconfig.use",false)) {
            return dhGlobal::db(Config::get("dbconfig"));
        }
        return dhGlobal::db();
    }

    public static function redis($redisconfig=null) {
        if($redisconfig) {
            $redis = new \Predis\Client($redisconfig);
            dhGlobal::set("redis",$redis);
            return $redis;
        }
        if(($redis= dhGlobal::get("redis",false)) !== false) {
            return $redis;
        }
        if(Config::get("redis")) {
            $config = Config::get("redis");
            if(is_array($config) && isset($config["passwrod"]) && !empty($config["password"])) {
                if(is_array($config["password"])) {
                    $arr = $config["password"];
                    unset($config["password"]);
                    $config["username"] = $arr[0];
                    $config["password"] = $arr[1];
                }
            }
            $redis = new \Predis\Client($config);
            dhGlobal::set("redis",$redis);
            return $redis;
        }
    }

    /**
     * @param array $qdrantconfig
     * @return \boru\qdrant\Qdrant
     */
    public static function qdrant($qdrantconfig=null) {
        if($qdrantconfig) {
            $qdrant = new \boru\qdrant\Qdrant($qdrantconfig);
            dhGlobal::set("qdrant",$qdrant);
            return $qdrant;
        }
        if(($qdrant = dhGlobal::get("qdrant",false)) !== false) {
            return $qdrant;
        }
        if(Config::get("qdrant")) {
            $config = Config::get("qdrant");
            $qdrant = new \boru\qdrant\Qdrant($config);
            dhGlobal::set("qdrant",$qdrant);
            return $qdrant;
        }
    }

    public static function loadTool($toolName) {
        if($toolName instanceof ToolDefinition) {
            return $toolName;
        }
        $className = "\\boru\\boruai\\Models\\Functions\\".$toolName;
        if(class_exists($className) && method_exists($className,"functionDefintions")) {
            return $className::functionDefintions();
        }
        return false;
    }

    private static $threaderInit = false;
    public static function initTaskQueue($options=[]) {
        if(static::$threaderInit) {
            return;
        }
        $defaultOptions = Config::get("threaderOptions",[]);
        $options = array_merge($defaultOptions,$options);
        TaskQueue::init($options);
        static::$threaderInit = true;
        static::registerFunctions();
    }
    public static function run_dococr($docId) {
        $document = new Document($docId);
        $document->ocr(false);
    }
    public static function run_upload($fileId) {
        $file = new File($fileId);
        return $file->upload();
    }
    public static function run_ocr($fileId,$options=[]) {
        $file = new File($fileId);
        $ocr = new OCR($file,$options);
        $result = $ocr->run();
        if($result) {
            $file->setOcr($result,$ocr->tokens());
        }
    }
    public static function registerFunctions() {
        $uploadFunction = function($fileId) {
            return BoruAI::run_upload($fileId);
        };
        $ocrFunction = function($fileId,$options=[]) {
            return BoruAI::run_ocr($fileId,$options);
        };
        $docOcrFunction = function($fileId,$options=[]) {
            return BoruAI::run_dococr($fileId,$options);
        };
        Task::register("upload",$uploadFunction);
        Task::register("ocr",$ocrFunction);
        Task::register("dococr",$docOcrFunction);
    }
    public static function threader($items,$callBack=null,$options=[]) {
        static::initTaskQueue();
        $defaultOptions = Config::get("threaderOptions",[]);
        $options = array_merge($defaultOptions,$options);
        return Threader::execute($items,$callBack,$options);
    }

    private static function projectRoot() {
        if(isset($GLOBALS['_composer_bin_dir'])) {
            $rootDir = realpath($GLOBALS['_composer_bin_dir']."/../../");
        } else {
            $dir = __DIR__;
            $myParent = "/vendor/boru/boruai/bin";
            if(substr($dir,-strlen($myParent))==$myParent) {
                //included as a dependency
                $rootDir = realpath($dir."/../../../../");
            } else {
                //in the boruai repository
                $rootDir = realpath($dir."/../");
            }
        }
        return $rootDir;
    }

    public static function registerEntities() {
        Factory::register(ChatSession::entityDefinition());
        Factory::register(Queue::entityDefinition());
        Factory::register(File::entityDefinition());
        Factory::register(Document::entityDefinition());
    }

    public static function executeCommand($commands=[]) {
        if(!is_array($commands)) {
            $commands = explode(" ",$commands);
        }
        BoruAICLI::parse($commands);
    }
}