<?php
namespace boru\boruai\Cli\Defs\Qdrant;

use boru\boruai\BoruAI;
use boru\cli\CLI;
use boru\cli\params\Flag;
use boru\cli\params\Option;
use boru\cli\params\Positional;
use boru\output\Output;
use boru\boruai\Openai\Api\Endpoints\FilesAPI;
use boru\boruai\Openai\OpenAIFile;
use boru\qdrant\api\CollectionsAPI;
use boru\qdrant\Docker;

trait QdrantDockerCLI {
    public static function def_qdrant_status() {
        return [
            "description"=> "Get Qdrant Docker Status",
        ];
    }

    public function cmd_qdrant_status($cmd) {
        $status = Docker::status();
        if(!$status) {
            Output::outLine("Qdrant Docker is not running");
            return;
        }
        Output::outLine("Qdrant Docker is running");
        $qdrant = BoruAI::qdrant();
        $collections = new CollectionsAPI($qdrant);
        $all = $collections->all();
        print_r($all);
    }

    public static function def_qdrant_start() {
        return [
            "description"=> "Start the Qdrant Docker container",
        ];
    }

    public function cmd_qdrant_start($cmd) {
        $result = Docker::start();
        Output::outLine($result["message"]);
    }

    public static function def_qdrant_stop() {
        return [
            "description"=> "Stop the Qdrant Docker container",
        ];
    }

    public function cmd_qdrant_stop($cmd) {
        $result = Docker::stop();
        Output::outLine($result["message"]);
    }

    public static function def_qdrant_restart() {
        return [
            "name"=> "Restart",
            "description"=> "Restart the Qdrant Docker container",
        ];
    }
    public function cmd_qdrant_restart($cmd) {
        $result = Docker::stop();
        if($result["success"]) {
            Output::outLine($result["message"]);
            $result = Docker::start();
            Output::outLine($result["message"]);
        }
    }
}