<?php
namespace boru\boruai\Models;

use boru\boruai\BoruAI;
use boru\query\Entity;
use boru\query\models\EntityDefinition;
use boru\query\Query;
use boru\boruai\Openai\OpenAIFile as OpenAIFile;
use boru\boruai\Openai\OpenAIUpload;
use boru\query\Factory;

class File extends Entity {
    /** @var OpenAIFile */
    private $openAIFile;


    public static function entityDefinition() {
        $tableName = BoruAI::table('files');
        return new EntityDefinition([
            "className" => static::class,
            "name" => "File",
            "queryBase" => Query::create()->select('*')->from($tableName),
            "createdField" => 'created_at',
        ]);
    }
    public function __construct($idOrData=null) {
        parent::__construct($idOrData);
        $this->set('ocr_tokens',"0");
    }

    //actions

    public function deleteLocal() {
        if($this->path() && file_exists($this->path())) {
            unlink($this->path());
        }
    }

    public function delete() {
        $this->deleteLocal();
        $this->openAIFile->delete();
        Query::create()->delete(BoruAI::table('files'))->where('id',"=",$this->id())->run();
    }

    public function upload($delete=false) {
        $upload = new OpenAIUpload();
        $upload->purpose($this->purpose());
        $upload->upload($this->path());
        $uploadfile = $upload->file()->toArray();
        if($uploadfile["id"] && $delete) {
            unlink($this->path());            
        }
        $uploadFile["fileid"] = $uploadfile["id"];
        unset($uploadfile["id"]);
        $this->file($upload->file());
        $this->fileid($upload->file()->id());
        $this->save();
    }

    public function queueUpload() {
        Queue::queue($this,"upload");
    }

    public function queueOcr() {
        Queue::queue($this,"ocr");
    }

    public function setOcr($content,$tokens=0) {
        $this->ocrContent($content);
        $this->ocrTokens($tokens);
        $this->ocrDate(date('Y-m-d H:i:s'));
        $this->save();
        if($this->docid()) {
            $doc = Factory::instanceById("Document",$this->docid());
            $doc->updateOcr();
        }
    }

    //getter and setter methods
    public function id($id=null) {
        if ($id !== null) {
            $this->set('id', $id);
            return $this;
        }
        return $this->get('id');
    }

    public function path($path=null) {
        if ($path !== null) {
            $this->set('path', $path);
            return $this;
        }
        return $this->get('path');
    }

    public function fileid($fileid=null) {
        if ($fileid !== null) {
            $this->set('fileid', $fileid);
            return $this;
        }
        return $this->get('fileid');
    }

    public function file($file=null) {
        if ($file !== null) {
            $this->openAIFile = $file;
            return $this;
        }
        if($this->openAIFile === null && $this->fileid()) {
            $this->openAIFile = OpenAIFile::fromId($this->fileid());
        }
        return $this->openAIFile;
    }

    public function docid($docid=null) {
        if ($docid !== null) {
            $this->set('docid', $docid);
            return $this;
        }
        return $this->get('docid');
    }

    public function object($object=null) {
        if ($object !== null) {
            $this->set('object', $object);
            return $this;
        }
        return $this->get('object');
    }

    public function created_at($created_at=null) {
        if ($created_at !== null) {
            $this->set('created_at', $created_at);
            return $this;
        }
        return $this->get('created_at');
    }

    public function filename($filename=null) {
        if ($filename !== null) {
            $this->set('filename', $filename);
            return $this;
        }
        return $this->get('filename');
    }

    public function purpose($purpose=null) {
        if ($purpose !== null) {
            $this->set('purpose', $purpose);
            return $this;
        }
        return $this->get('purpose');
    }

    public function bytes($bytes=null) {
        if ($bytes !== null) {
            $this->set('bytes', $bytes);
            return $this;
        }
        return $this->get('bytes');
    }

    public function md5($md5=null) {
        if ($md5 !== null) {
            $this->set('md5', $md5);
            return $this;
        }
        return $this->get('md5');
    }

    public function ocrContent($ocr_content=null) {
        if ($ocr_content !== null) {
            $this->set('ocr_content', $ocr_content);
            return $this;
        }
        return $this->get('ocr_content');
    }

    public function ocrDate($ocr_date=null) {
        if ($ocr_date !== null) {
            $this->set('ocr_date', $ocr_date);
            return $this;
        }
        return $this->get('ocr_date');
    }

    public function ocrTokens($ocr_tokens=null) {
        if ($ocr_tokens !== null) {
            $this->set('ocr_tokens', $ocr_tokens);
            return $this;
        }
        return $this->get('ocr_tokens');
    }

    //static methods

    public static function fromFile($file) {
        $file = new static($file->toArray());
        $file->file($file);
        return $file;
    }

    public static function create($path,$docId=null,$purpose=null) {
        $file = new static();
        $file->path($path);
        $file->filename(basename($path));
        if($docId) {
            $file->docid($docId);
            if(!$purpose) {
                $doc = new Document($docId);
                $purpose = $doc->purpose();
            }
        }
        $file->purpose($purpose);
        $file->save();
        return $file;
    }

    public static function uploadFile($filename,$purpose="assistants",$docId=null,$queue=false) {
        if(!BoruAI::isCLI()) {
            throw new \Exception("File::upload() can only be done from CLI",0);
        }
        $file = new static();
        $file->path($filename);
        $file->filename(basename($filename));
        $file->purpose($purpose);
        if($docId) {
            $file->docid($docId);
        }
        $file->save();
        if($queue) {
            Queue::queue($file,"upload");
        } else {
            $file->upload();
        }
        $file = new static($file->id());
        return $file;
    }
}