<?php
namespace boru\boruai\Models\Functions;

use boru\boruai\Models\ToolDefinition;
use boru\boruai\Models\Tool;
use boru\dhutils\tools\Output;

abstract class FunctionBase {

    /**
     * Return an array of function definitions
     * 
     * @return ToolDefinition[]
     */
    abstract public static function functionDefintions();



    private static $debug = false;
    private static $debugOutput = false;
    private static $isInit = false;
    private static $statusCallback = true;

    public static function init() {
        if(static::$isInit) {
            return;
        }
        static::$isInit = true;
        if(static::$debug) {
            Output::outLine(static::class."::init()");
        }
    }

    public static function debug($debug=null) {
        if($debug !== null) {
            static::$debug = $debug;
        }
        return static::$debug;
    }
    public static function debugOutput($debugOutput=null) {
        if($debugOutput !== null) {
            static::$debugOutput = $debugOutput;
        }
        return static::$debugOutput;
    }
    public static function statusCallback($statusCallback=null) {
        if($statusCallback !== null) {
            static::$statusCallback = $statusCallback;
        }
        return static::$statusCallback;
    }

    
    /**
     * Return the name of the function
     * @param string $method The name of the function
     * @param Tool $tool The tool object, including the arguments, accessable via $tool->get()
     * @return mixed The result of the function to be returned to the Chat/Assistant.
     */
    public static function callback($method,$tool) {
        //get the called class:
        $class = get_called_class();
        if(static::debug()) {
            Output::outLine(static::class,"::$method");
            Output::outLine($tool->get());
        }
        if(method_exists($class,$method)) {
            $result = call_user_func([$class,$method],$tool);
            if(is_array($result)) {
                //$result = json_encode($result,JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
                $result = Tool::printArray($result);
            }
            if(static::debugOutput()) {
                static::debugOutput(false);
                Output::outLine("VtigerToolFunctions -- $method RESULT:",$result);
            }
            return $result;
        }
        return null;
    }

    public static function statusUpdate($status) {
        if(static::$statusCallback) {
            if(is_callable(static::$statusCallback)) {
                $callback = static::$statusCallback;
                $callback($status);
            } else {
                Output::outLine($status);
            }
        }
    }
}