<?php
namespace boru\boruai\Models;

use boru\dot\Dot;

class Tool {
    private static $tools = [];

    private $name;
    private $arguments = [];
    private $tool_call_id;
    private $callback;
    public function __construct($input = [],$name=null) {
        //openai tool callback:
        if(
                isset($input["type"]) && $input["type"] == "function"
            && isset($input["id"])
            && isset($input["function"])
            && isset($input["function"]["name"])
            && isset($input["function"]["arguments"])
        ) {
            $this->name = $input["function"]["name"];
            $this->arguments = $input["function"]["arguments"];
            $this->tool_call_id = $input["id"];
        } else {
            $this->name = $name;
            $this->arguments = $input;
        }
        if(isset(static::$tools[$this->name])) {
            $this->callback = static::$tools[$this->name];
        }
        if(is_string($this->arguments) && substr($this->arguments,0,1) == "{") {
            $this->arguments = json_decode($this->arguments,true);
        }elseif(is_string($this->arguments) && substr($this->arguments,0,1) == "[") {
            $this->arguments = json_decode($this->arguments,true);
        }
    }
    public static function register($name,$callback) {
        static::$tools[$name] = $callback;
    }

    public function name($name=null) {
        if($name !== null) {
            $this->name = $name;
            return $this;
        }
    }
    public function arguments($arguments=null) {
        if($arguments !== null) {
            $this->arguments = $arguments;
            return $this;
        }
    }
    public function tool_call_id($tool_call_id=null) {
        if($tool_call_id !== null) {
            $this->tool_call_id = $tool_call_id;
            return $this;
        }
    }
    public function callback($callback=null) {
        if($callback !== null) {
            $this->callback = $callback;
            return $this;
        }
    }

    public function run() {
        if($this->callback) {
            $output = call_user_func($this->callback,$this);
            if($output !== false) {
                return [
                    "tool_call_id"=>$this->tool_call_id,
                    "output"=>$output
                ];
            }
        }
        return null;
    }

    public function get($key=null,$default=null) {
        if($key === null) {
            return $this->arguments;
        }
        return Dot::get($this->arguments,$key,$default);
    }
    public function set($key,$value) {
        return Dot::set($this->arguments,$key,$value);
    }

    public static function printArray($array) {
        $lines = [];
        $output = [];
        foreach($array as $key=>$value) {
            if(is_array($value)) {
                $lines[] = static::printArray($value);
            } else {
                if(is_numeric($key)) {
                    $output[] = $value;
                } else {
                    $output[] = "$key: $value";
                }
            }
        }
        $lines[] = implode(", ",$output);
        return implode("\n",$lines);
    }
}