<?php
namespace boru\boruai\Models\Vectorstore;

use boru\boruai\Models\Distance\Euclidean;
use boru\boruai\Models\VectorDocument;
use boru\openai\OpenAI;
use boru\openai\OpenAIConfig;

class MemoryVectorStore extends VectorStore {
    /** @var VectorDocument[] */
    private $documents = [];

    /** @var DistanceInterface */
    private $distance;

    public function distance($distance=null) {
        if($distance !== null) {
            $this->distance = $distance;
        }
        if($this->distance === null) {
            $this->distance = new Euclidean();
        }
        return $this->distance;
    }

    public function addDocument(VectorDocument $document) {
        //trigger embedding if not already embedded
        $document->embed();
        //add to the store
        $this->documents[$document->id()] = $document;
    }

    public function addDocuments(array $documents) {
        foreach($documents as $document) {
            $this->addDocument($document);
        }
    }

    public function similarity($embedding, $k = 4, $extraArgs = []) {
        $distances  = [];
        foreach($this->documents as $i=>$document) {
            $dist = $this->distance()->measure($embedding, $document->embedding());
            if($dist !== false) {
                $distances[$i] = $dist;
            }
        }
        asort($distances);
        $distances = array_slice(array_keys($distances), 0, $k, true);

        $results = [];
        foreach($distances as $i) {
            $results[] = $this->documents[$i];
        }
        return $results;
    }
}