<?php
namespace boru\boruai\Models\Vectorstore;

use boru\boruai\BoruAI;
use boru\boruai\Models\Embedding;
use boru\boruai\Openai\OpenAIEmbedding;
use boru\qdrant\models\Collection;
use boru\qdrant\models\Point;
use boru\qdrant\models\params\VectorParams;

class QdrantVectorStore {
    /** @var \boru\qdrant\Qdrant */
    private $qdrant;
    /** @var string */
    private $collectionName = "default";
    /** @var int */
    private $vectorSize = 1536;

    /** @var Collection */
    private $collection;

    public function __construct($collectionName = null, $qdrant = null) {
        $this->qdrant($qdrant);
        $this->collectionName($collectionName);
        $this->initCollection();
    }

    /**
     * @param \boru\qdrant\Qdrant|null $qdrant
     * @return \boru\qdrant\Qdrant
     */
    public function qdrant($qdrant = null) {
        if ($qdrant !== null) {
            $this->qdrant = $qdrant;
        }
        if($this->qdrant === null) {
            $this->qdrant = BoruAI::qdrant();
        }
        return $this->qdrant;
    }

    /**
     * @param string|null $collectionName
     * @return string
     */
    public function collectionName($collectionName = null) {
        if ($collectionName !== null) {
            $this->collectionName = $collectionName;
        }
        return $this->collectionName;
    }

    public function addDocument($document,$id=null) {
        $point = $this->convertDocumentToPoint($document,$id);
        $this->collection->addPoint($point);
    }

    public function addDocuments(array $documents) {
        $points = [];
        foreach($documents as $document) {
            $points[] = $this->convertDocumentToPoint($document);
        }
        $this->collection->addPoints($points);
    }

    /**
     * @param Point|array|string $document
     * @param string|int|null $id
     * @return Point
     */
    private function convertDocumentToPoint($document,$id=null) {
        if(!$document instanceof Point) {
            if(is_array($document) || is_object($document)) {
                if(isset($document["id"]) && $id === null) {
                    $id = $document["id"];
                }
                $embedString = json_encode($document,JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
            } else {
                $embedString = $document;
                $document = [
                    "content" => $document
                ];
            }
            $embedding = Embedding::embed($embedString);
            if($id === null) {
                $id = uniqid("",true);
            }
            return new Point($id,$embedding,$document); 
        }
        return $document;
    }

    public function search($query,$limit=10) {
        $vector = Embedding::embed($query,true,true);
        return $this->collection->search($vector,null,$limit);
    }


    private function initCollection() {
        $this->collection = new Collection($this->collectionName,new VectorParams($this->vectorSize,"Cosine"));
        $this->collection->save();
    }
}