<?php
namespace boru\boruai\Models\Vectorstore;

use boru\boruai\Models\VectorDocument;
use boru\openai\models\Chat;

abstract class VectorStore {
    abstract public function addDocument(VectorDocument $document);
    abstract public function addDocuments(array $documents);
    abstract public function similarity($embedding, $k = 4, $extraArgs = []);

    protected function embedDocument(VectorDocument $document,$force=false) {
        $document->embed($force);
    }


    public static function generateTestDocuments($num=100) {
        return VectorDocument::generateTestDocuments($num);
    }
}