<?php
namespace boru\boruai\Openai\Models;

class Content extends BaseModel {

    private $body;

    public function __construct($contentBody=[]) {
        if(!is_array($contentBody)) {
            $this->body = [];
            if(is_string($contentBody)) {
                $this->addText($contentBody);
            } else {
                throw new \Exception("Options must be an array or string");
            }
        }
        $this->body = $contentBody;
    }

    public function addText($text) {
        $this->body[] = [
            "type"=> "text",
            "text"=>$text,
        ];
        return $this;
    }
    public function addImageFile($fileId,$detail="high") {
        $this->body[] = [
            "type"=> "image_file",
            "image_file"=>["file_id"=>$fileId,"detail"=>$detail],
        ];
        return $this;
    }
    public function addAudioFile($fileId) {
        $this->body[] = [
            "type"=> "audio_file",
            "audio_file"=>["file_id"=>$fileId],
        ];
        return $this;
    }
    public function addImageUrl($url) {
        $this->body[] = [
            "type"=> "image_url",
            "image_url"=>["url"=>$url],
        ];
        return $this;
    }
    public function addBase64Image($pathToFile,$mimeType=null) {
        if($mimeType && !file_exists($pathToFile)) {
            $base64 = base64_encode($pathToFile);
        } else {
            if(!file_exists($pathToFile)) {
                throw new \Exception("File not found");
            }
            if(!$mimeType) {
                $mimeType = mime_content_type($pathToFile);
            }
            $fileContent = file_get_contents($pathToFile);
            $base64 = base64_encode($fileContent);
        }
        $base64String = "data:".$mimeType.";base64,".$base64;
        return $this->addImageUrl($base64String);
    }


    public function toArray() {
        return $this->body;
    }

}