<?php
namespace boru\boruai\Openai;

use boru\boruai\Openai\Api\Endpoints\ThreadsAPI;
use boru\boruai\Openai\Models\BaseModel;
use boru\boruai\Openai\Models\Messages;
use boru\boruai\Openai\Models\Content;

class OpenAIThread extends BaseModel {
    private $id;
    private $object = "thread";
    private $createdAt;
    private $metadata;

    /** @var Messages */
    private $messages;

    public function __construct($options=[]) {
        $this->messages = new Messages();
        if(isset($options["messages"])) {
            foreach($options["messages"] as $msg) {
                $this->addMessage($msg["role"],$msg["content"],isset($msg["attachments"]) ? $msg["attachments"] : [],isset($msg["metadata"]) ? $msg["metadata"] : []);
            }
            unset($options["messages"]);
        }
        parent::__construct($options);
    }

    public function id($id=null) {
        if ($id) {
            $this->id = $id;
        }
        return $this->id;
    }
    public function object($object=null) {
        if ($object) {
            $this->object = $object;
        }
        return $this->object;
    }
    public function createdAt($created=null) {
        if ($created) {
            $this->createdAt = $created;
        }
        return $this->createdAt;
    }
    public function metadata($metadata=null) {
        if ($metadata) {
            $this->metadata = $metadata;
        }
        return $this->metadata;
    }

    public function save() {
        $data = [];
        if($this->metadata) {
            $data["metadata"] = $this->metadata;
        }
        $result = ThreadsAPI::create($data);
        $this->id($result->id());
        $this->object($result->object());
        $this->createdAt($result->createdAt());
        $this->metadata($result->metadata());
        if(!empty($this->messages)) {
            foreach($this->messages as $message) {
                $message->threadId($this->id());
                $message->save();
            }
        
        }
    }
    public function addMessage($role,$content,$attachments=[],$metadata=[]) {
        if($content instanceof Content) {
            $content = $content->toArray();
        }
        $data = [
            "role" => $role,
            "content" => $content,
            "attachments" => $attachments,
            "metadata" => $metadata
        ];
        $result = new OpenAIMessage($data);
        $this->messages->add($result);
    }
    public function message($message) {
        if($this->messages === null) {
            $this->messages = new Messages();
        }
        $this->messages->add($message);
        return $this;
    }
    /**
     * 
     * @param bool $forRun 
     * @return array|Messages
     */
    public function getMessages($forRun=true) {
        if(!$forRun) {
            return $this->messages;
        }
        return $this->messages->toArray(false);
        /*$messages = [];
        foreach($this->messages as $message) {
            $messages[] = $message->forThread();
        }
        return $messages;*/
    }

    public function toArray() {
        return [
            "id" => $this->id(),
            "object" => $this->object(),
            "created_at" => $this->createdAt(),
            "metadata" => $this->metadata()
        ];
    }
}