<?php
namespace boru\boruai\Vtiger;

use boru\boruai\BoruAI;
use boru\query\Query;
use Exception;

class VtigerModule {
    private static $modulesCache = [];
    /**
     * List active modules
     * @return array
     */
    public static function listModules() {
        if(empty(static::$modulesCache)) {
            static::loadModules();
        }
        return static::$modulesCache;
    }

    /**
     * Get module by name
     * @param string $name
     * @return array
     */
    public static function getModuleByName($name) {
        if(empty(static::$modulesCache)) {
            static::loadModules();
        }
        return static::getModule($name,"name");
    }

    /**
     * Get module by id
     * @param int $id
     * @return array
     */
    public static function getModuleById($id) {
        if(empty(static::$modulesCache)) {
            static::loadModules();
        }
        return static::getModule($id,"tabid");
    }

    /**
     * Get module by field value
     * @param mixed $value 
     * @param string $field 
     * @return mixed 
     * @throws Exception 
     */
    public static function getModule($value,$field="name") {
        if(empty(static::$modulesCache)) {
            static::loadModules();
        }
        foreach(static::$modulesCache as $module) {
            if($module[$field] == $value) {
                return $module;
            }
        }
        return null;
    }

    /**
     * Load modules
     * @return void
     */
    private static function loadModules() {
        static::$modulesCache = [];
        foreach(Query::create()->select("*")->from("vtiger_tab")->where("presence","=","0")->toRows() as $row) {
            static::$modulesCache[$row->get("tabid")] = $row->asArray();
        }
        return static::$modulesCache;
    }
}