<?php

use boru\dhapi\API;
use boru\dhapi\routing\Route;
use boru\dhapi\routing\Router;
use boru\boruai\BoruAI;

require __DIR__."/init.php";

if(BoruAI::config("web.enabled",false) !== true) {
    die("Web API is not enabled\n");
}

$router = new Router();
$router->add(new Route("SessionChat",       "/session/chat",            ["GET","POST"], ["Session\\SessionChatAPI","process"]));
$router->add(new Route("SessionDelete",     "/session/delete",          ["GET","POST"], ["Session\\SessionDeleteAPI","process"]));
$router->add(new Route("SessionList",       "/session/list",            ["GET","POST"], ["Session\\SessionListAPI","process"]));
$router->add(new Route("SessionId",         "/session/{session}",       ["GET","POST"], ["Session\\SessionChatAPI","process"]));
$router->add(new Route("SessionChatId",     "/session/chat/{session}",  ["GET","POST"], ["Session\\SessionChatAPI","process"]));

$router->add(new Route("ModelList",         "/model/list",              ["GET","POST"], ["Model\\ModelListAPI","process"]));
$router->add(new Route("ModelGet",          "/model/{model}",           ["GET","POST"], ["Model\\ModelGetAPI","process"]));
$router->add(new Route("ModelGet2",         "/model/get",               ["GET","POST"], ["Model\\ModelGetAPI","process"]));


$request = API::requestFromGlobals();
$api = new API($request,$router);
$api->setClassBaseNamespace("\\boru\\boruai\\Api\\");

$response = $api->process();
$response->emit(true);