<?php
namespace boru\boruai\Cli;

use boru\boruai\BoruAI;
use boru\boruai\Config;
use boru\boruai\Models\Configuration;
use boru\cli\CLIInterface;
use boru\cli\params\Option;
use boru\boruai\Openai\OpenAI;
use boru\cli\params\Positional;
use boru\output\Output;

class BoruAICLI extends CLIInterface {
    public static function CLI_def() {
        return [
            "name"=> "Boru AI CLI",
            "description"=> "A command line interface for the Boru AI API",
            "params" => [
                Option::create("c|config|The configuration file to use"),
                Option::create("k|key|The API key to use"),
            ]
        ];
    }

    public function __construct($command) {
        Output::init(["prefix"=>false]);
        parent::__construct($command);
        $config = $this->get("config",false);
        $apiKey = $this->get("key",false);
        if($config) {
            try {
                BoruAI::init($config);
            } catch(\Exception $e) {
                Output::outLine("Error: " . $e->getMessage());
                exit();
            }
        } elseif($apiKey) {
            try {
                BoruAI::init(["openai"=>["api_key"=>$apiKey]]);
            } catch(\Exception $e) {
                Output::outLine("Error: " . $e->getMessage());
                exit();
            }
        } else {
            try {
                BoruAI::init();
            } catch(\Exception $e) {
                Output::outLine("Error: " . $e->getMessage());
                exit();
            }
        }
        if(!Config::get("openai.api_key", "")) {
            Output::outLine("Error: No API key found. Please provide an API key using the -k option or in the configuration file.");
            exit();
        }
    }

    use \boru\boruai\Cli\Defs\OpenAICLI;
    use \boru\boruai\Cli\Defs\QdrantCLI;
    use \boru\boruai\Cli\Defs\ConfigCLI;
    use \boru\boruai\Cli\Defs\SessionCLI;
    use \boru\boruai\Cli\Defs\DocumentCLI;
    use \boru\boruai\Cli\Defs\QueueCLI;
    use \boru\boruai\Cli\Defs\ChatCLI;
}