<?php
namespace boru\boruai\Cli\Defs;

use boru\boruai\BoruAI;
use boru\boruai\Models\ChatSession;
use boru\cli\CLI;
use boru\cli\params\Flag;
use boru\cli\params\Option;
use boru\cli\params\Positional;
use boru\output\Output;
use boru\boruai\Openai\Api\Endpoints\AssistantsAPI;
use boru\boruai\Openai\OpenAIAssistant;
use boru\boruai\Openai\OpenAIChat;

trait ChatCLI {
    public static function def_chat() {
        return [
            "description"=> "Chat Operations",
            "params" => [
                Positional::create("+phrase|The phrase to chat with"),
                Option::create("p|prompt|The prompt or txt file to use as the prompt, if any -- preceeding the phrase"),
                Option::create("+f|file|The file(s) to embed into the chat"),
                Option::create("o|output|The name of the file to write the file data to"),
                Option::create("+t|tool|Tool(s) to use for the chat"),
                Flag::create("force|Force overwrite of the output file"),
            ]
        ];
    }

    public function cmd_chat($cmd) {
        $chat = new OpenAIChat();
        
        $phrase = $cmd->get("phrase");
        $prompt = $cmd->get("prompt");
        $files = $cmd->get("file");
        $output = $cmd->get("output");
        $tools = $cmd->get("tool");
        if($prompt) {
            if(file_exists($prompt)) {
                $prompt = file_get_contents($prompt);
                $prompt = str_replace("\n"," ",$prompt);
            }
            $chat->addMessage("system", $prompt);
        }
        if(empty($phrase) && empty($prompt)) {
            $lines = $this->captureInput2();
            $phrase = implode("\n",$lines);
        }
        if(!empty($tools)) {
            if(!is_array($tools)) {
                $tools = [$tools];
            }
            foreach($tools as $toolInput) {
                $tool = BoruAI::loadTool($toolInput);
                if($tool) {
                    if(is_array($tool)) {
                        $chat->addTools($tool);
                        Output::outLine("Using tools:",implode(", ",array_map(function($t){return $t->name();},$tool)));
                    } else {
                        Output::outLine("Using tool:",$tool->name());
                        $chat->addTool($tool);
                    }
                } else {
                    Output::outLine("Tool not found:",$toolInput);
                    exit(1);
                }
            }
        }
        if(!empty($files)) {
            if(!is_array($files)) {
                $files = [$files];
            }
            foreach($files as $file) {
                if(file_exists($file)) {
                    //if it is a txt file, get the contents.. otherwise use the file as is.
                    if(pathinfo($file, PATHINFO_EXTENSION) == "txt") {
                        $content = file_get_contents($file);
                        $content = str_replace("\n"," ",$file);
                        Output::outLine("Embedding file content from",$file);
                        $chat->addMessage("user", "Use the contents of the file:\n".$content);
                    } else {
                        Output::outLine("Embedding file",$file);
                        $chat->addMessage("user", "Use the file",$file);
                    }
                } else {
                    Output::outLine("File not found: ".$file);
                }
            }
        }
        if(!empty($phrase)) {
            $phrase = implode(" ",$phrase);
            $chat->addMessage("user", $phrase);
            Output::outLine("Sending:",$phrase);
        }
        
        
        Output::outLine("--- Chat ---");
        $result = $chat->run();
        Output::outLine("Result:");
        Output::outLine($result);
        Output::outLine("--- /Chat ---");
        if($output) {
            if(file_exists($output)) {
                if($cmd->get("force")) {
                    Output::outLine("Overwriting output file:", $output);
                } else {
                    Output::outLine("Output file exists. Use --force to force overwrite");
                    return;
                }
            }
            if(is_dir($output)) {
                Output::outLine("Output file is a directory");
                return;
            }
            file_put_contents($output, $result);
            Output::outLine("File written to", $output);
        }
    }

    private function captureInput2() {
        $term = "/s";
        $line = null;
        $lines = [];
        Output::outLine("Enter your chat messages. Type '/s' to stop.");
        while($line != "/s") {
            $line = CLI::promptInput(" -> ");
            if($line != "/s") {
                $lines[] = $line;
            }
        }
        return $lines;
    }
}