<?php
namespace boru\boruai\Cli\Defs\Openai;

use boru\boruai\Models\ChatSession;
use boru\cli\CLI;
use boru\cli\params\Flag;
use boru\cli\params\Option;
use boru\cli\params\Positional;
use boru\output\Output;
use boru\boruai\Openai\Api\Endpoints\AssistantsAPI;
use boru\boruai\Openai\OpenAIAssistant;
use boru\boruai\Openai\OpenAIChat;

trait ChatCLI {
    public static function def_openai_openai_chat() {
        return [
            "description"=> "Chat Operations",
            "params" => [
                Positional::create("+phrase|The phrase to chat with"),
            ]
        ];
    }

    public function cmd_openai_openai_chat($cmd) {
        $chat = new OpenAIChat();
        
        $phrase = $cmd->get("phrase");
        if(empty($phrase)) {
            $lines = $this->captureInput();
            $phrase = implode("\n",$lines);
        } else {
            $phrase = implode(" ",$phrase);
            Output::outLine("Sending:",$phrase);
        }
        


        $chat = new OpenAIChat();
        $chat->addMessage("user", $phrase);
        Output::outLine("--- Chat ---");
        Output::outLine($chat->run());
        Output::outLine("--- /Chat ---");
    }

    private function captureInput() {
        $term = "/s";
        $line = null;
        $lines = [];
        Output::outLine("Enter your chat messages. Type '/s' to stop.");
        while($line != "/s") {
            $line = CLI::promptInput(" -> ");
            if($line != "/s") {
                $lines[] = $line;
            }
        }
        return $lines;
    }
}