<?php
namespace boru\boruai\Models;

use boru\boruai\BoruAI;
use boru\query\Query;
use boru\query\Entity;
use boru\query\models\EntityDefinition;
use boru\boruai\Openai\OpenAIChat;
use boru\boruai\Openai\OpenAIAssistant;
use boru\boruai\Openai\OpenAIMessage;
use boru\boruai\Openai\Response\Parts\OutputMessage;
use boru\boruai\Openai\Response\ResponseObject;
use boru\boruai\Tools\CodeTool;
use boru\boruai\Tools\Util;
use boru\output\Output;
use boru\query\Factory;
use Exception;

class ResponseHistory extends Entity {
    private static $isInit = false;
    public static function entityDefinition() {
        $tableName = BoruAI::table('responses');
        $query = Query::create()->select('id','reference','created_at','model','response_id','input','output','result','compressed_input')->from($tableName);
        return new EntityDefinition([
            "className" => static::class,
            "name" => "ResponseHistory",
            "queryBase" => $query,
            "jsonFields" => ['input','output'],
            "createdField" => "created_at",
        ]);
    }

    /** @var ResponseObject */
    private $inputObject;
    /** @var ResponseObject */
    private $outputObject;

    public static function doInit() {
        if(!self::$isInit) {
            self::$isInit = true;
            Factory::register(static::entityDefinition());
        }
    }

    public function __construct($input=null) {
        self::doInit();
        parent::__construct($input);
    }

    public function id() {
        return $this->get("id");
    }

    public function reference($reference=null) {
        if ($reference) {
            $this->set("reference",$reference);
        }
        return $this->get("reference");
    }

    public function createdAt($createdAt=null) {
        if ($createdAt) {
            $this->set("created_at",$createdAt);
        }
        return $this->get("created_at");
    }
    public function responseId($responseId=null) {
        if ($responseId) {
            $this->set("response_id",$responseId);
        }
        return $this->get("response_id");
    }
    public function result($result=null) {
        if ($result) {
            $this->set("result",$result);
        }
        return $this->get("result");
    }
    public function compressedInput($input=null) {
        if ($input) {
            if(is_array($input)) {
                if(isset($input["instructions"])) {
                    unset($input["instructions"]);
                }
            }
            $input = Util::compress($input);
            $this->set("compressed_input",$input);
        }
        $content = $this->get("compressed_input");
        if($content) {
            $content = Util::decompress($content);
            return $content;
        }
    }

    public function input($input=null) {
        if ($input) {
            if($input instanceof ResponseObject) {
                $this->inputObject = $input;
                $this->model($input->model());
                $input = $input->forInput();
            } elseif(is_array($input)) {
                if(!isset($input["input"])) {
                    $input = ["input"=>$input];
                }
                $object = new ResponseObject($input);
                return $this->input($object);
            }
            if($this->inputObject) {
                $this->compressedInput($input);
                $input = $this->inputObject->forInput(true);
            }
            $this->set("input",$input);
        }
        if($this->inputObject) {
            return $this->inputObject;
        }
        return $this->get("input");
    }
    public function output($output=null) {
        if ($output) {
            if($output instanceof ResponseObject) {
                $this->outputObject = $output;
                $this->result($output->getResult());
                $this->responseId($output->id());
                $output = $output->toArray();
            } elseif(is_array($output)) {
                $object = new ResponseObject($output);
                return $this->output($object);
            }
            $this->set("output",$output);
        }
        if($this->outputObject) {
            return $this->outputObject;
        }
        $output = $this->get("output");
        if($output && is_array($output)) {
            $object = new ResponseObject($output);
            $this->outputObject = $object;
            $this->set("output",$object->toArray());
            return $this->outputObject;
        }
        return $this->get("output");
    }
    public function model($model=null) {
        if ($model) {
            $this->set("model",$model);
        }
        $model = $this->get("model");
        if(!$model && $this->inputObject) {
            $model = $this->inputObject->model();
            $this->set("model",$model);
        }
        if(!$model && $this->outputObject) {
            $model = $this->outputObject->model();
            $this->set("model",$model);
        }
        return $model;
    }

    /**
     * 
     * @param mixed $responseId 
     * @return false|self
     * @throws Exception 
     */
    public static function fromId($id) {
        self::doInit();
        $instance = Factory::instanceById("ResponseHistory",$id);
        if(!$instance) {
            return new self($instance->id());
        }
        return $instance;
    }

    /**
     * 
     * @param mixed $responseId 
     * @return false|self
     * @throws Exception 
     */
    public static function fromReference($reference) {
        self::doInit();
        $db = BoruAI::db();
        $query = Factory::query("ResponseHistory");
        $query->where("reference","=",$reference);
        $query->limit(0,1);
        $query->orderBy("id","desc");
        $instance = $query->toRow();
        if(!$instance) {
            return false;
        }
        $instance = Factory::instanceById("ResponseHistory",$instance->get("id"));
        if(!$instance) {
            return false;
        }
        return $instance;
    }

    /**
     * 
     * @param mixed $responseId 
     * @return false|self
     * @throws Exception 
     */
    public static function fromResponseId($responseId) {
        self::doInit();
        $db = BoruAI::db();
        $instance = Factory::search("ResponseHistory",[0,1],["response_id","=",$responseId]);
        if(!$instance) {
            return false;
        }
        return $instance[0];
    }

    public static function deleteByReference($reference) {
        self::doInit();
        $db = BoruAI::db();
        $db->printDebug(true);
        $query = Factory::query("ResponseHistory");
        $query->delete()->where("reference","=",$reference);
        $query->run();
    }
}