<?php
namespace boru\boruai\Openai\Stream;

use boru\boruai\Openai\Models\BaseModel;

class StreamEvent extends BaseModel {
    private $type;
    private $data = [];

    public function type($eventType=null) {
        if ($eventType !== null) {
            $this->type = $eventType;
        }
        return $this->type;
    }
    public function data($data=null) {
        if ($data !== null) {
            $this->data = $data;
        }
        return $this->data;
    }

    public function toArray() {
        return $this->data;
    }
    public static function fromEvent($eventJsonOrArray,$callback=null) {
        if (is_string($eventJsonOrArray)) {
            $eventArray = json_decode($eventJsonOrArray, true);
        } elseif(is_array($eventJsonOrArray)) {
            $eventArray = $eventJsonOrArray;
        } else {
            throw new \Exception("Invalid event data");
        }
        if (isset($eventArray['type'])) {
            //response.output_text.delta
            //response.in_progress => Response\\InProgress
            $parts = explode('.', $eventArray['type']);
            $className = 'boru\\boruai\\Openai\\Stream\\';
            $classParts = [];
            while(count($parts) > 0) {
                $part = array_shift($parts);
                $subParts = explode('_', $part);
                $subParts = array_map('ucfirst', $subParts);
                $part = implode('', $subParts);
                $classParts[] = $part;
            }
            $className .= implode('\\', $classParts);
            if (class_exists($className)) {
                $event = new $className($eventArray);
                if ($event instanceof StreamEvent) {
                    if ($callback && is_callable($callback)) {
                        $event = call_user_func($callback, $event);
                    }
                    return $event;
                } else {
                    throw new \Exception("Class $className is not a StreamEvent");
                }
            } else {
                throw new \Exception("Class $className does not exist");
            }
        }
        return null;
    }

    public const FUNCTION_CALL_COMPLETED = "function_call.completed";
    public const FUNCTION_CALL_FAILED = "function_call.failed";
    public const FUNCTION_CALL_FUNCTION_CALL_BASE = "function_call";
    public const FUNCTION_CALL_STARTED = "function_call.started";
    public const RESPONSE_OUTPUT_ITEM_DONE = "response.output_item.done";
    public const RESPONSE_OUTPUT_ITEM_ADDED = "response.output_item.added";
    public const RESPONSE_FUNCTION_CALL_ARGUMENTS_DELTA = "response.function_call_arguments.delta";
    public const RESPONSE_FUNCTION_CALL_ARGUMENTS_DONE = "response.function_call_arguments.done";
    public const RESPONSE_FILE_SEARCH_CALL_SEARCHING = "response.file_search_call.searching";
    public const RESPONSE_FILE_SEARCH_CALL_COMPLETED = "response.file_search_call.completed";
    public const RESPONSE_FILE_SEARCH_CALL_IN_PROGRESS = "response.file_search_call.in_progress";
    public const RESPONSE_COMPLETED = "response.completed";
    public const RESPONSE_WEB_SEARCH_CALL_SEARCHING = "response.web_search_call.searching";
    public const RESPONSE_WEB_SEARCH_CALL_COMPLETED = "response.web_search_call.completed";
    public const RESPONSE_WEB_SEARCH_CALL_IN_PROGRESS = "response.web_search_call.in_progress";
    public const RESPONSE_INCOMPLETE = "response.incomplete";
    public const RESPONSE_FAILED = "response.failed";
    public const RESPONSE_IN_PROGRESS = "response.in_progress";
    public const RESPONSE_CONTENT_PART_DONE = "response.content_part.done";
    public const RESPONSE_CONTENT_PART_ADDED = "response.content_part.added";
    public const RESPONSE_REFUSAL_DELTA = "response.refusal.delta";
    public const RESPONSE_REFUSAL_DONE = "response.refusal.done";
    public const RESPONSE_REASONING_SUMMARY_PART_DELTA = "response.reasoning_summary_part.delta";
    public const RESPONSE_REASONING_SUMMARY_PART_DONE = "response.reasoning_summary_part.done";
    public const RESPONSE_REASONING_SUMMARY_TEXT_DELTA = "response.reasoning_summary_text.delta";
    public const RESPONSE_REASONING_SUMMARY_TEXT_DONE = "response.reasoning_summary_text.done";
    public const RESPONSE_OUTPUT_TEXT_DELTA = "response.output_text.delta";
    public const RESPONSE_OUTPUT_TEXT_DONE = "response.output_text.done";
    public const RESPONSE_OUTPUT_TEXT_ADDED = "response.output_text.added";
    public const RESPONSE_CREATED = "response.created";
    public const RESPONSE_ERROR = "response.error";
}