<?php
namespace boru\boruai\Tools;

class PromptTemplate {
    private $data = [];
    private $prompt;

    private $renderedPrompt;

    public function __construct($prompt=null,$data=[]) {
        $this->setPrompt($prompt);
        $this->setData($data);
    }

    public function data($data=null) {
        if ($data !== null) {
            $this->data = $data;
        }
        return $this->data;
    }

    public function setPrompt($prompt) {
        $this->prompt = $prompt;
    }
    public function setData($data) {
        $this->data = $data;
    }

    public function prompt($prompt=null) {
        $updated = false;
        if ($prompt !== null) {
            $this->prompt = $prompt;
            $updated = true;
        }
        if($this->prompt && (!$this->renderedPrompt || $updated)) {
            $this->renderedPrompt = $this->renderPrompt($this->data);
        }
        return $this->renderedPrompt;
    }

    public function render($data=null) {
        $updated = false;
        if($data !== null) {
            $this->data = $data;
            $updated = true;
        }
        if($this->prompt && (!$this->renderedPrompt || $updated)) {
            $this->renderedPrompt = $this->renderPrompt($this->data);
        }
        return $this->renderedPrompt;
    }

    public function renderPrompt($data) {
        $template = $this->prompt();
        if(empty($template)) {
            return false;
        }
        // Render the template with the provided data
        return $this->doRenderTemplate($template, $data);
    }

    /**
     * Render a template with the provided data.
     * 
     * @param string $template The template string.
     * @param array $data The data to replace in the template.
     * @return string The rendered template.
     */
    private function doRenderTemplate($template, $data=[]) {
        // Check if the template is a file
        if (file_exists($template)) {
            $template = file_get_contents($template);
        }
        // Check if the template is a URL
        if (filter_var($template, FILTER_VALIDATE_URL)) {
            $template = file_get_contents($template);
        }
        foreach ($data as $key => $value) {
            // Handle loop blocks for non-associative arrays
            if (is_array($value) && array_keys($value) === range(0, count($value) - 1)) {
                // Match loop blocks like {loop=key}...{/loop=key}
                if (preg_match_all('/\{loop=' . preg_quote($key) . '\}(.*?)\{\/loop=' . preg_quote($key) . '\}/s', $template, $matches, PREG_SET_ORDER)) {
                    foreach ($matches as $match) {
                        $loopContent = '';
                        foreach ($value as $item) {
                            $segment = $match[1];
                            // If the item is an array, recursively process it
                            if (is_array($item)) {
                                $segment = $this->doRenderTemplate($segment, $item);
                            } else {
                                $segment = str_replace('{' . $key . '}', $item, $segment);
                            }
                            $loopContent .= $segment;
                        }
                        $template = str_replace($match[0], $loopContent, $template);
                    }
                }
            } elseif (is_array($value)) {
                // Recursively process sub-arrays
                $template = $this->doRenderTemplate($template, $value);
            } else {
                // Replace simple {key} with value
                $template = str_replace('{' . $key . '}', $value, $template);
            }
        }
    
        return $template;
    }
}