<?php
namespace boru\boruai\Vtiger;

use boru\boruai\BoruAI;
use boru\query\Query;

class VtigerFields {
    private static $moduleFieldsCache = [];

    /**
     * Get fields for a module
     * @param int|string $tabIdOrModuleName The tabid or module name
     * @return array array of fields with fieldname as key, [fieldlabel, uitype, typeofdata, presence, columnname] as value
     */
    public static function getFields($tabIdOrModuleName) {
        if(!is_numeric($tabIdOrModuleName)) {
            $tabIdOrModuleName = VtigerModule::getModuleByName($tabIdOrModuleName);
            $tabId = $tabIdOrModuleName['tabid'];
        } else {
            $tabId = $tabIdOrModuleName;
        }
        if(isset(static::$moduleFieldsCache[$tabId])) {
            return static::$moduleFieldsCache[$tabId];
        }
        $fields = Query::create()
            ->select("fieldid, columnname, tablename, fieldlabel, uitype, typeofdata, presence")
            ->from("vtiger_field")
            ->where("tabid","=",$tabId)
            ->toRows();
        foreach($fields as $field) {
            static::$moduleFieldsCache[$tabId][$field->get('fieldname')] = $field->asArray();
            if($field->get('uitype') == 10) {
                $relatedModules = static::getFieldRelatedModules($field->get('fieldid'));
                static::$moduleFieldsCache[$tabId][$field->get('fieldname')]['relatedModules'] = $relatedModules;
            } elseif($field->get('uitype') == 15) {
                $picklistValues = static::getPicklistValues($field->get('fieldname'));
                static::$moduleFieldsCache[$tabId][$field->get('fieldname')]['picklistValues'] = $picklistValues;
            }
        }
        return static::$moduleFieldsCache[$tabId];
    }

    private static function getFieldRelatedModules($fieldId) {
        $rows = Query::create()
            ->select("*")
            ->from("vtiger_fieldmodulerel")
            ->where("fieldid","=", $fieldId)
            ->toRows();
        $modules = [];
        foreach($rows as $row) {
            $modules[] = $row->get("relmodule");
        }
        //return $field['tabid'];
    }

    private static function getPicklistValues($fieldname) {
        $rows = Query::create()
            ->select($fieldname)
            ->from("vtiger_".$fieldname)
            ->toRows();
        $values = [];
        foreach($rows as $row) {
            $values[] = $row->get($fieldname);
        }
        return $values;
    }
}