$(document).ready(function() {
    const apiEndpoint = '/api'; // Define the API endpoint

    // Function to list sessions
    function listSessions() {
        $.ajax({
            url: `${apiEndpoint}/sessions`,
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                const sessionList = $('#sessions');
                sessionList.empty();
                data.sessions.forEach(function(session) {
                    sessionList.append(`<li class="list-group-item">${session.name} <button class="btn btn-danger btn-sm float-right delete-session" data-id="${session.id}">Delete</button></li>`);
                });
            }
        });
    }

    // Function to create a new session
    $('#create-session-form').submit(function(event) {
        event.preventDefault();
        const sessionName = $('#session-name').val();

        $.ajax({
            url: `${apiEndpoint}/sessions`,
            type: 'POST',
            data: JSON.stringify({ name: sessionName }),
            contentType: 'application/json',
            success: function(response) {
                $('#session-name').val('');
                listSessions();
            }
        });
    });

    // Function to delete a session
    $('#sessions').on('click', '.delete-session', function() {
        const sessionId = $(this).data('id');
        $.ajax({
            url: `${apiEndpoint}/sessions/${sessionId}`,
            type: 'DELETE',
            success: function(response) {
                listSessions();
            }
        });
    });

    // Function to send a message
    $('#send-message-form').submit(function(event) {
        event.preventDefault();
        const messageContent = $('#message-content').val();
        const sessionId = $('#current-session').data('id');

        $.ajax({
            url: `${apiEndpoint}/sessions/${sessionId}/chat`,
            type: 'POST',
            data: JSON.stringify({ message: messageContent }),
            contentType: 'application/json',
            success: function(response) {
                $('#message-content').val('');
                updateChatHistory(response.history);
                $('#tool-output').text(response.toolCalls);
            }
        });
    });

    // Function to update chat history
    function updateChatHistory(messages) {
        const chatHistory = $('#chat-history');
        chatHistory.empty();
        messages.forEach(function(message) {
            chatHistory.append(`<div><strong>${message.role}</strong>: ${message.content}</div>`);
        });
    }

    // Initially list sessions
    listSessions();
});
