<?php
namespace boru\boruai\Models;

use boru\boruai\Openai\Models\BaseModel;
use boru\boruai\Openai\OpenAIChat;
use boru\boruai\Openai\OpenAIEmbedding;

class VectorDocument extends BaseModel {
    /** @var array|string */
    private $content;
    /** @var string */
    private $formattedContent;
    /** @var array */
    private $embedding;
    /** @var string */
    private $hash;
    /** @var string */
    private $name = "auto";
    /** @var string */
    private $type = "auto";
    /** @var int */
    private $index;
    /** @var string */
    private $headerFormat = "";

    /** @var mixed */
    private $id;
    //private $headerFormat = "The name of the name is: {{NAME}}\n";

    public function toArray() {
        return [
            "content" => $this->content(),
            "formattedContent" => $this->formattedContent(),
            "hash" => $this->hash, // we wont force the hash to be generated here.
            "name" => $this->name(),
            "type" => $this->type(),
            "embedding" => $this->embedding,
            "index" => $this->index()
        ];
    }

    public function id($id=null) {
        if($id !== null) {
            $this->id = $id;
        }
        if($id===null) {
            return $this->generateId();
        }
        return $this->id;
    }

    public function generateId() {
        $type = $this->type();
        if(empty($type)) {
            $type = "auto";
        }
        $name = $this->name();
        if(empty($name)) {
            $name = "auto";
        }
        $index = $this->index();
        if(empty($index)) {
            $index = 0;
        }
        $id = $type."_".$name."_".$index;
        if($id == "auto_auto_0") {
            $id = $this->hash();
        }
        return $id;
    }


    /**
     * @param string|null $content
     * @return string
     */
    public function content($content=null) {
        if ($content!==null) {
            $this->content = $content;
        }
        return $this->content;
    }
    /**
     * @param string|null $formattedContent
     * @return string
     */
    public function formattedContent($formattedContent=null) {
        if ($formattedContent!==null) {
            $this->formattedContent = $formattedContent;
        }
        if($this->formattedContent === null && $this->content !== null && is_string($this->content)) {
            $this->format();
        }
        return $this->formattedContent;
    }
    /**
     * @param array|null $embedding
     * @return array
     */
    public function embedding($embedding=null) {
        if ($embedding!==null) {
            $this->embedding = $embedding;
        }
        if($this->embedding === null && $this->formattedContent !== null) {
            $this->embed(true);
        } elseif($this->embedding === null && $this->content !== null) {
            $this->embed();
        }
        return $this->embedding;
    }
    /**
     * @param string|null $name
     * @return string
     */
    public function name($name=null) {
        if ($name!==null) {
            $this->name = $name;
        }
        return $this->name;
    }
    /**
     * @param string|null $type
     * @return string
     */
    public function type($type=null) {
        if ($type!==null) {
            $this->type = $type;
        }
        return $this->type;
    }
    /**
     * @param string|null $hash
     * @return string
     */
    public function hash($hash=null) {
        if ($hash!==null) {
            $this->hash = $hash;
        }
        if($this->hash === null) {
            $this->hash = hash("sha256", $this->formattedContent());
        }
        return $this->hash;
    }
    /**
     * @param int|null $index
     * @return int
     */
    public function index($index=null) {
        if ($index!==null) {
            $this->index = $index;
        }
        return $this->index;
    }

    public function embed($force=false,$model=null) {
        if($this->embedding !== null && !$force) {
            return $this->embedding;
        }
        $embedding = false;
        if($this->formattedContent !== null) {
            $embedding = new OpenAIEmbedding($this->formattedContent(),$model);
        } elseif($this->content !== null) {
            if(is_array($this->content)) {
                $data = "";
                foreach($this->content as $key=>$value) {
                    $data .= $key.": ".$value."\n";
                }
                $embedding = new OpenAIEmbedding($data,$model);
            } else {
                $embedding = new OpenAIEmbedding($this->content(),$model);
            }
        }
        $this->embedding = $embedding->embedding();
        return $this->embedding;
    }


    private function format() {
        $header = str_replace("{{NAME}}", $this->name, $this->headerFormat);
        $header = str_replace("{{TYPE}}", $this->type, $header);
        $this->formattedContent = $header.$this->content;
    }

    public static function fromJson($json) {
        $data = json_decode($json, true);
        if(is_array($data) && !empty($data)) {
            $document = new VectorDocument($data);
            return $document;
        } else {
            throw new \Exception("Failed to decode json");
        }
    }

    public static function generateTestDocuments($num=100) {
        //lets use chatGPT to give us $num lines of random text, each line being it's own document
        //usage is this:
        /*
        $chat = new Chat();
        $chat->addMessage("user","Hello world, test.. only a very small response, please");
        $return = $chat->run();
        print_r($return);
        */
        $chat = new OpenAIChat();
        $documents = [];
        $chat->addMessage("user","
I need $num randomly generated 'documents' to test vector similarity.
A 'document' is just a single line of text. Please use a very wide range of topics to choose from in the random text, as we want to test similiarty searches.
Please generate them for me without prefixing them in any way, just the text.. an example output would be:

The quick brown fox jumps over the lazy dog
The quick brown fox jumps over the lazy dog
The sun is shining brightly in the clear blue sky
The cat curled up on the windowsill and fell asleep
A delicious aroma wafted from the kitchen, making my stomach growl
The rustling leaves whispered secrets in the gentle breeze
        ");
        $return = $chat->run();
        $lines = explode("\n",$return);
        $i=0;
        foreach($lines as $line) {
            $i++;
            $name = date("YmdHis")."_".$i;
            $line = trim($line);
            if($line != "") {
                $documents[] = new VectorDocument(["type"=>"random","name"=>"gpt_".$name,"content"=>$line]);
            }
        }
        return $documents;
    }
}