<?php
namespace boru\boruai\Openai\Api\Endpoints;

use boru\boruai\Openai\Api\Responses\ApiBaseResponse;
use boru\boruai\Openai\OpenAIFile;
use boru\boruai\Openai\OpenAI;

class FilesAPI {
    public static function listFiles($parameters=[]) {
        return OpenAI::requestList("get","files",$parameters,OpenAIFile::class);
    }

    public static function upload($parameters=[]) {
        return OpenAI::upload("files",$parameters);
    }

    public static function delete($file_id) {
        return OpenAI::request("delete","files/".$file_id);
    }

    public static function get($file_id) {
        return OpenAI::request("get","files/".$file_id);
    }

    public static function content($file_id) {
        return OpenAI::rawRequest("get","files/".$file_id."/content");
    }
}