<?php
namespace boru\boruai\Openai;


use boru\boruai\Openai\Api\Endpoints\AudioAPI;
use boru\boruai\Openai\Models\BaseModel;


class OpenAISpeech extends BaseModel {
    private $model = "tts-1";
    private $input;
    private $voice = "alloy";
    private $responseFormat = "mp3";
    private $speed = 1;

    public function model($model=null) {
        if ($model) {
            $this->model = $model;
        }
        return $this->model;
    }
    public function input($input=null) {
        if ($input) {
            $this->input = $input;
        }
        return $this->input;
    }
    public function voice($voice=null) {
        if ($voice) {
            $this->voice = $voice;
        }
        return $this->voice;
    }
    public function responseFormat($responseFormat=null) {
        if ($responseFormat) {
            $this->responseFormat = $responseFormat;
        }
        return $this->responseFormat;
    }
    public function speed($speed=null) {
        if ($speed) {
            $this->speed = $speed;
        }
        return $this->speed;
    }

    public function run($filename=null) {
        $parameters = $this->toArray();
        if(!$filename) {
            return AudioAPI::speech($parameters);
        }
        file_put_contents($filename, AudioAPI::speech($parameters));
        return $filename;
    }

    public static function fromArray($array,$filenameOrTrueIfRun=null) {
        $speech = new OpenAISpeech($array);
        if($filenameOrTrueIfRun) {
            if($filenameOrTrueIfRun === true) {
                $filenameOrTrueIfRun = null;
            }
            return $speech->run($filenameOrTrueIfRun);
        }
        return $speech;
    }
    public static function create($input,$fileName=null,$voice="alloy",$model="tts-1",$responseFormat="mp3",$speed=1) {
        $array = [
            "model" => $model,
            "input" => $input,
            "voice" => $voice,
            "response_format" => $responseFormat,
            "speed" => $speed
        ];
        return self::fromArray($array,$fileName);
    }
    public static function createHd($input,$fileName=null) {
        return self::create($input,$fileName,"alloy","tts-1-hd","mp3",1);
    }




    public function toArray() {
        return [
            "model" => $this->model,
            "input" => $this->input,
            "voice" => $this->voice,
            "response_format" => $this->responseFormat,
            "speed" => $this->speed
        ];
    }
}