<?php
namespace boru\boruai\Openai\Stream\Response;

use boru\boruai\Openai\Stream\StreamEvent;

class Incomplete extends StreamEvent {
    const TYPE = 'response.incomplete';
    private $id;
    private $response;

    public function id($id=null) {
        if ($id) {
            $this->id = $id;
        }
        return $this->id;
    }
    public function response($responseObject=null) {
        if ($responseObject) {
            $this->response = $responseObject;
        }
        return $this->response;
    }

    public function toArray() {
        $result = [
            'type' => $this->type(),
            'id' => $this->id(),
            'response' => null
        ];
        if(is_object($this->response)) {
            $result['response'] = $this->response->toArray();
        } elseif(is_array($this->response)) {
            $result['response'] = $this->response;
        } else {
            $result['response'] = $this->response;
        }
        return $result;
    }
}