<?php
namespace boru\boruai\UI\Actions;

use boru\boruai\Models\Response;
use boru\boruai\Models\ResponseHistory;

class ResponseAction extends Ajax {
    private $user;
    private $reference;
    public function handle() {
        static::init(true);
        $messageId = $this->request("responseId");
        $result = [
            "response_id" => $messageId,
            "output" => ""
        ];
        if(!$messageId) {
            Ajax::error($result, "No message ID provided");
            Ajax::response([
                "success" => false,
                "error" => "No message ID provided"
            ]);
            return;
        }
        
        $response = Response::fromId($messageId);
        if($response) {
            $result["output"] = $response->getResult();
            $result["response_id"] = $response->id();
            $result["status"] = $response->status();

        }
        Ajax::success($result);
    }
}