<?php
namespace boru\boruai\Socket;

class SocketAPI {
    private $auth = '';
    private $headers = [
        'Content-Type: application/json',
    ];
    private $apiUrl = "";

    private static $instance = null;

    public static function init($config=[]) {
        if(static::$instance === null) {
            static::$instance = new self($config);
        }
        return static::$instance;
    }

    public static function getInstance() {
        if(static::$instance === null) {
            static::$instance = new self();
        }
        return static::$instance;
    }

    public function __construct($socketConfig=[]) {
        if(empty($socketConfig)) {
            $socketConfig = \boru\boruai\BoruAI::socketConfig();
        }
        if(isset($socketConfig['url_base']) && isset($socketConfig['api_port'])) {
            $this->apiUrl = rtrim($socketConfig['url_base'], '/').':'.$socketConfig['api_port'];
        } else {
            $this->apiUrl = 'http://localhost:5001';
        }
        if(isset($socketConfig['auth']) && !empty($socketConfig['auth'])) {
            $this->auth = $socketConfig['auth'];
            $this->headers[] = 'xauth: '.$this->auth;
        }
        if(isset($socketConfig['headers']) && is_array($socketConfig['headers'])) {
            foreach($socketConfig['headers'] as $key => $value) {
                $this->headers[] = "$key: $value";
            }
        }
        if(static::$instance === null) {
            static::$instance = $this;
        }
    }

    public function api_event($event,$target,$payload) {
        $data = ["event"=>$event,"target"=>$target,"payload"=>$payload];
        $result = $this->_parse($this->post($this->apiUrl."/event",json_encode($data)));
        file_put_contents('notification.log',date("Y-m-d H:i:s")." -- ".print_r($result, true)."\n",FILE_APPEND);
        if($result !== false)
            return true;
        return false;
    }

    public function _parse($resp) {
        if(!is_array($resp) || !isset($resp["status"]) || !isset($resp["data"]))
            return false;

        if($resp["status"]==200) {
            $data = json_decode($resp["data"],true);
            if(is_array($data) && isset($data["success"]) && $data["success"])
                return $data;
        }
        return false;
    }

    public function _call($type,$uri,$parms=array(),$auth=false,$timeout=30,$ssl_verify=false) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,$uri);
        //curl_setopt($ch, CURLOPT_VERBOSE, true);
        curl_setopt($ch, CURLOPT_ENCODING, '');
        curl_setopt($ch, CURLOPT_HTTPHEADER, $this->headers);
        curl_setopt($ch, CURLOPT_HEADER,true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $ssl_verify);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
        //curl_setopt($ch, CURLOPT_VERBOSE, true);
        if($auth !== false) {
            curl_setopt($ch, CURLOPT_USERPWD, $auth);
        }

        switch($type) {
            case 'GET':
                if(strpos($uri,"?") == false) $uri.='?';
                $uri.=http_build_query($parms);
                break;
            case 'POST':
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $parms);
                break;
            case 'DELETE':
            case 'HEAD':
            case 'PUT':
            default:
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, strtoupper($type));
                curl_setopt($ch, CURLOPT_POSTFIELDS, $parms);
        }


        $response  = curl_exec($ch);
        $info = curl_getinfo($ch);
        curl_close($ch);
        //echo $parms."\n";
        return array(
            'status'=>$info['http_code'],
            'header'=>trim(substr($response,0,$info['header_size'])),
            'data'=>substr($response,$info['header_size'])
        );
    }

    public function get($uri,$parms=array(),$auth=false,$timeout=30) {
        return $this->_call("GET",$uri,$parms,$auth,$timeout);
    }
    public function post($uri,$parms=array(),$auth=false,$timeout=30) {
        return $this->_call("POST",$uri,$parms,$auth,$timeout);
    }
    public function put($uri,$parms=array(),$auth=false,$timeout=30) {
        return $this->_call("PUT",$uri,$parms,$auth,$timeout);
    }
    public function head($uri,$parms=array(),$auth=false,$timeout=30) {
        return $this->_call("HEAD",$uri,$parms,$auth,$timeout);
    }
    public function delete($uri,$parms=array(),$auth=false,$timeout=30) {
        return $this->_call("DELETE",$uri,$parms,$auth,$timeout);
    }


}