<?php
namespace boru\boruai\Socket;

/**
 * Connects to the socket and listens for events to trigger actions.
 * @package boru\boruai\Socket
 */
class SocketListener {

    private $socketUrl;
    private $socketPort;
    private $authToken;

    private $eventHandlers = [];

    public function __construct($config=[]) {
        if(empty($config)) {
            $config = \boru\boruai\BoruAI::socketConfig();
        }
        if(isset($config['url_base']) && isset($config['socket_port'])) {
            $this->socketUrl = rtrim($config['url_base'], '/').':'.$config['socket_port'];
        } else {
            $this->socketUrl = 'http://localhost';
        }
        $this->socketPort = isset($config['socket_port']) ? $config['socket_port'] : 5000;
        $this->authToken = isset($config['auth']) ? $config['auth'] : '';
    }

    public function connect() {
        // Implement the logic to connect to the socket server
        // This could involve using a library like Ratchet or similar
        // For example:
        // $this->socket = new \Ratchet\Client\WebSocket($this->socketUrl, $this->socketPort, $this->authToken);
    }

    /**
     * Handles incoming events from the socket.
     * This method should be called when an event is received.
     * @param mixed $event 
     * @param mixed $data 
     * @return void 
     */
    private function handleEvent($event, $data) {
        if(isset($this->eventHandlers[$event])) {
            foreach($this->eventHandlers[$event] as $handler) {
                call_user_func($handler, $data);
            }
        }
    }

    public function on($event, callable $handler) {
        if(!isset($this->eventHandlers[$event])) {
            $this->eventHandlers[$event] = [];
        }
        $this->eventHandlers[$event][] = $handler;
    }
}