<?php
namespace boru\boruai\Models\Functions;

use boru\boruai\Models\ToolDefinition;
use boru\boruai\Tools\CodeManager;
use boru\boruai\Tools\Util;
use boru\dhutils\tools\Output;

class ResponseGroup extends FunctionBase {
    private static $responseGroup = null;
    public static function init($responseGroup=null) {
        if($responseGroup) {
            static::$responseGroup = $responseGroup;
        }
        return static::$responseGroup;
    }
    public static function setResponseGroup($responseGroup) {
        static::$responseGroup = $responseGroup;
    }

    public static function userDetails($args) {
        $responseGroup = static::init();
        if(!$responseGroup) {
            return "No information available";
        }

        $information = $args->get("information");
        $instructions = $args->get("instructions");
        if($information || $instructions) {
            $responseGroup->set("information",$information);
            $responseGroup->set("instructions",$instructions);
            $responseGroup->save();
        }

        
        $information = $responseGroup->get("information");
        $instructions = $responseGroup->get("instructions");
        if(!$information && !$instructions) {
            return "No information available";
        }
        $output = [];
        if($information) {
            $output[] = "Information: ".$information;
        }
        if($instructions) {
            $output[] = "Instructions: ".$instructions;
        }
        if(!empty($output)) {
            $output[] = "Please make sure to retain the important information from this conversation.";
        }
        return "----------\nPreviously known information::\n".implode("\n",$output)."----------\n\n";
    }

    /**
     * 
     * @return ToolDefinition[]
     */
    public static function functionDefintions() {
        $return = [];
        $responseGroup = static::init();
        if($responseGroup->isNewResponseGroup()) {
            $language = "Since this is hte first interaction, please make sure to call this function and save any";
        } else {
            $language = "Call this function to save any new or updated";
        }

        $toolDefinition = new ToolDefinition();
        $toolDefinition->name("user_details");
        $toolDefinition->description($language." important information or instructions that was provided to the AI. This will help guide future interactions.");
        $toolDefinition->addString("information", "All relevant information to save, in string format.");
        $toolDefinition->addString("instructions", "All relevant instructions to save, in string format.");
        $toolDefinition->register(function($args) {
            return static::callback("userDetails",$args);
        });
        $return[] = $toolDefinition;

        return $return;
    }
}