<?php
namespace boru\boruai\Openai\Stream\FunctionCall;

use boru\boruai\Openai\Stream\StreamEvent;

class FunctionCallBase extends StreamEvent {
    const TYPE = "function_call";
    private $id;
    private $name;
    private $args;
    private $callId;
    private $status;


    public function name($name=null) {
        if ($name !== null) {
            $this->name = $name;
        }
        return $this->name;
    }
    public function args($args=null) {
        if ($args) {
            $this->args = $args;
        }
        return $this->args;
    }
    public function callId($callId=null) {
        if ($callId) {
            $this->callId = $callId;
        }
        return $this->callId;
    }
    public function status($status=null) {
        if ($status) {
            $this->status = $status;
        }
        return $this->status;
    }
    public function id($id=null) {
        if ($id) {
            $this->id = $id;
        }
        return $this->id;
    }

    public function toArray() {
        return [
            'type' => $this->type(),
            'id' => $this->id(),
            'name' => $this->name(),
            'args' => $this->args(),
            'callId' => $this->callId(),
            'status' => $this->status(),
        ];
    }
}