<?php
namespace boru\boruai\Openai\Api\Endpoints;

use boru\boruai\Openai\OpenAIMessage;
use boru\boruai\Openai\OpenAI;

class MessagesAPI {
    public static function create($threadId,$parameters=[]) {
        return new OpenAIMessage(OpenAI::request("post","threads/".$threadId."/messages",$parameters));
    }
    public static function listMessages($threadId) {
        return OpenAI::requestList("get","threads/".$threadId."/messages",[],OpenAIMessage::class);
        //return OpenAI::request("get","threads/".$threadId."/messages");
    }
    public static function getMessage($threadId,$messageId) {
        return new OpenAIMessage(OpenAI::request("get","threads/".$threadId."/messages/".$messageId));
    }
    public static function update($threadId,$messageId,$parameters=[]) {
        return new OpenAIMessage(OpenAI::request("post","threads/".$threadId."/messages/".$messageId,$parameters));
    }
    
}