<?php
namespace boru\boruai\Models\Functions;

use boru\boruai\BoruAI;
use boru\boruai\Models\ToolDefinition;
use boru\boruai\Models\Tool;
use boru\output\Output;

abstract class FunctionBase {

    /**
     * Return an array of function definitions
     * 
     * @return ToolDefinition[]
     */
    abstract public static function functionDefintions();



    protected static $debug = false;
    protected static $debugOutput = false;
    protected static $isInit = false;
    protected static $statusCallback = true;

    public static function init() {
        if(static::$isInit) {
            return;
        }
        static::$isInit = true;
        BoruAI::printToolDebug(static::class."::init()");
    }

    public static function debug($debug=null) {
        if($debug !== null) {
            static::$debug = $debug;
        }
        return static::$debug;
    }
    public static function debugOutput($debugOutput=null) {
        if($debugOutput !== null) {
            static::$debugOutput = $debugOutput;
        }
        return static::$debugOutput;
    }
    public static function statusCallback($statusCallback=null) {
        if($statusCallback !== null) {
            static::$statusCallback = $statusCallback;
        }
        return static::$statusCallback;
    }

    
    /**
     * Return the name of the function
     * @param string $method The name of the function
     * @param Tool $tool The tool object, including the arguments, accessable via $tool->get()
     * @return mixed The result of the function to be returned to the Chat/Assistant.
     */
    public static function callback($method,$tool) {
        //get the called class:
        $class = get_called_class();
        $classParts = explode("\\",$class);
        $classString = array_pop($classParts);
        BoruAI::printToolDebug($classString."::$method");
        BoruAI::printToolDebug($tool->get());
        if(method_exists($class,$method)) {
            $result = call_user_func([$class,$method],$tool);
            if(is_array($result)) {
                //$result = json_encode($result,JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
                $result = Tool::printArray($result);
            }
            if(static::debugOutput()) {
                static::debugOutput(false);
                BoruAI::printToolDebug("$classString::$method\n Function Result:\n",$result);
                BoruAI::printToolDebug("");
            }
            return $result;
        }
        return null;
    }

    public static function statusUpdate($status) {
        if(static::$statusCallback) {
            if(is_callable(static::$statusCallback)) {
                $callback = static::$statusCallback;
                $callback($status);
            } else {
                BoruAI::printToolDebug($status);
            }
        }
    }
}