<?php
namespace boru\boruai\Models;

class ToolProperty {
    private $name;
    private $type;
    private $description;
    private $required = true;
    private $enum = [];
    /** @var ToolProperty[] */
    private $subProperties = [];

    public function __construct($input=[]) {

        $this->name = isset($input["name"]) ? $input["name"] : null;
        $this->type = isset($input["type"]) ? $input["type"] : null;
        $this->description = isset($input["description"]) ? $input["description"] : null;
        $this->required = isset($input["required"]) ? $input["required"] : true;
        $this->enum = isset($input["enum"]) ? $input["enum"] : [];
        $this->subProperties = isset($input["properties"]) ? $input["properties"] : [];
    }
    
    public function name($name=null) {
        if($name !== null) {
            $this->name = $name;
            return $this;
        }
        return $this->name;
    }

    public function type($type=null) {
        if($type !== null) {
            $this->type = $type;
            return $this;
        }
        return $this->type;
    }

    public function description($description=null) {
        if($description !== null) {
            $this->description = $description;
            return $this;
        }
        return $this->description;
    }

    public function required($required=null) {
        if($required !== null) {
            $this->required = $required ? true : false;
            return $this;
        }
        return $this->required;
    }

    public function enum($values=[]) {
        $this->enum = $values;
        return $this;
    }

    public function compile($root=true) {
        if($this->type == "anyOf") {
            $arr = [];
            foreach($this->subProperties as $subProperty) {
                $arr[$subProperty->name()] = $subProperty->compile();
            }
            return [
                "anyOf" => $arr
            ];
        }
        $array = [
            "type" => $this->type,
            "description" => $this->description,
        ];
        if(count($this->enum) > 0) {
            $array["enum"] = $this->enum;
        }
        return $array;
    }
}