<?php
namespace boru\boruai\UI\Actions;

use boru\boruai\Models\Template;

class ToolAction extends Ajax {

    public function handle() {
        static::init(true);
        $mode = $this->request("mode");
        if(!$mode) {
            Ajax::error([], "No mode provided");
            return;
        }
        $method = "handle" . ucfirst($mode)."Tool";
        if(!method_exists($this, $method)) {
            Ajax::error([], "Invalid mode provided");
            return;
        }
        return $this->$method();
    }

    public function handleEnableTool() {
        $tool = $this->request("tool");
        if(!$tool) {
            Ajax::error([], "No tool provided");
            return;
        }
        
        $result = [
            "success" => true,
            "tool" => $tool
        ];
        Ajax::response($result);
        return;

    }
}