<?php

use boru\boruai\Openai\OpenAIEmbedding;
use boru\qdrant\Models\Collection;
use boru\qdrant\Models\Params\VectorParams;
use boru\qdrant\Models\Point;
use boru\qdrant\Qdrant;

require __DIR__."/init.php";

$dim = 3072; //text-embedding-3-large

$vectorParams = VectorParams::OpenAI($dim);
$collection = new Collection("test_collection_name_here",$vectorParams);
$collection->save(); //creates the collection if it doesn't exist already.

$client = Qdrant::instance();

//add a couple sample records.. note that the ID must either be an integer or a uidv5 string.. nothing else works for the ID.
$objects = [
    ["string"=>"the big read boat",
    "payload"=>["color"=>"blue","size"=>"big"],
    "id"=>"1"],
    ["string"=>"the small blue boat",
    "payload"=>["color"=>"blue","size"=>"small"],
    "id"=>"2"],
    ["string"=>"the purple gas guzzling car",
    "payload"=>["color"=>"purple","size"=>"medium"],
    "id"=>"3"],
    ["string"=>"the fast red motorcycle",
    "payload"=>["color"=>"red","size"=>"small"],
    "id"=>"4"]
];
//embed the strings using the BoruAI embedding function (which uses OpenAI by default)
$embeddings = [];
foreach($objects as $k=>$object) {
    $embedding = new OpenAIEmbedding($object["string"],"text-embedding-3-large");
    $objects[$k]["vector"] = $embedding->embedding();
}

foreach($objects as $object) {
    $point = new Point((int) $object["id"],$object["vector"],$object["payload"]);
    $collection->addPoint($point);
}

//search for similar items..
$searchString = "boat";
$embedding = new OpenAIEmbedding($searchString,"text-embedding-3-large");
$vector = $embedding->embedding();

//search for similar items..
$results = $collection->search($vector);
foreach($results as $point) {
    print_r($point->toArray());
    echo "\n";
}