<?php
namespace boru\boruai\Api;

use boru\dhapi\core\Response;
use boru\dhapi\core\Dispatcher;

abstract class BaseAPI {
    abstract public function execute();

    private $api;

    /**
     * Deletes a chat session.
     * 
     * @param Dispatcher $api 
     * @return mixed
     */
    public function process($api) {
        $this->api = $api;
        if($this->auth($api)) {
            return $this->execute();
        }
        return $this->error("Unauthorized",403);
    }

    public function auth($api) {
        return true;
    }

    public function get($key,$default=null) {
        return $this->api->arg($key,"__NOT_SET__")==="__NOT_SET__" ? $this->api->body($key,$default) : $this->api->arg($key,$default);
    }
    public function arg($key,$default=null) {
        return $this->api->arg($key,$default);
    }
    public function body($key,$default=null) {
        return $this->api->body($key,$default);
    }

    public function error($message,$code=400) {
        $packet = [
            "success"=>false,
            "message"=>$message
        ];
        return Response::fromError($packet,$code);
    }

    public function success($message) {
        $packet = [
            "success"=>true,
            "message"=>$message
        ];
        return Response::fromSuccess($packet);
    }
}